/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchainquery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.managedblockchainquery.model.TransactionOutputItem;
import java.util.Date;

@SdkInternalApi
public class TransactionOutputItemMarshaller {
    private static final MarshallingInfo<String> TRANSACTIONHASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionHash").build();
    private static final MarshallingInfo<String> NETWORK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("network").build();
    private static final MarshallingInfo<Date> TRANSACTIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transactionTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CONFIRMATIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("confirmationStatus").build();
    private static final TransactionOutputItemMarshaller instance = new TransactionOutputItemMarshaller();

    public static TransactionOutputItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(TransactionOutputItem transactionOutputItem, ProtocolMarshaller protocolMarshaller) {
        if (transactionOutputItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)transactionOutputItem.getTransactionHash(), TRANSACTIONHASH_BINDING);
            protocolMarshaller.marshall((Object)transactionOutputItem.getNetwork(), NETWORK_BINDING);
            protocolMarshaller.marshall((Object)transactionOutputItem.getTransactionTimestamp(), TRANSACTIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)transactionOutputItem.getConfirmationStatus(), CONFIRMATIONSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

