/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceagreement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.marketplaceagreement.model.DocumentItem;

@SdkInternalApi
public class DocumentItemMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final DocumentItemMarshaller instance = new DocumentItemMarshaller();

    public static DocumentItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentItem documentItem, ProtocolMarshaller protocolMarshaller) {
        if (documentItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentItem.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)documentItem.getUrl(), URL_BINDING);
            protocolMarshaller.marshall((Object)documentItem.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

