/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mturk;

import javax.annotation.Generated;

import com.amazonaws.services.mturk.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonMTurk}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonMTurk implements AmazonMTurk {

    protected AbstractAmazonMTurk() {
    }

    @Override
    public AcceptQualificationRequestResult acceptQualificationRequest(AcceptQualificationRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ApproveAssignmentResult approveAssignment(ApproveAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateQualificationWithWorkerResult associateQualificationWithWorker(AssociateQualificationWithWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAdditionalAssignmentsForHITResult createAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHITResult createHIT(CreateHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHITTypeResult createHITType(CreateHITTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateHITWithHITTypeResult createHITWithHITType(CreateHITWithHITTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQualificationTypeResult createQualificationType(CreateQualificationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkerBlockResult createWorkerBlock(CreateWorkerBlockRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteHITResult deleteHIT(DeleteHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQualificationTypeResult deleteQualificationType(DeleteQualificationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkerBlockResult deleteWorkerBlock(DeleteWorkerBlockRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateQualificationFromWorkerResult disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountBalanceResult getAccountBalance(GetAccountBalanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssignmentResult getAssignment(GetAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFileUploadURLResult getFileUploadURL(GetFileUploadURLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetHITResult getHIT(GetHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQualificationScoreResult getQualificationScore(GetQualificationScoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQualificationTypeResult getQualificationType(GetQualificationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssignmentsForHITResult listAssignmentsForHIT(ListAssignmentsForHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListBonusPaymentsResult listBonusPayments(ListBonusPaymentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHITsResult listHITs(ListHITsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListHITsForQualificationTypeResult listHITsForQualificationType(ListHITsForQualificationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQualificationRequestsResult listQualificationRequests(ListQualificationRequestsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQualificationTypesResult listQualificationTypes(ListQualificationTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReviewPolicyResultsForHITResult listReviewPolicyResultsForHIT(ListReviewPolicyResultsForHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReviewableHITsResult listReviewableHITs(ListReviewableHITsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkerBlocksResult listWorkerBlocks(ListWorkerBlocksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkersWithQualificationTypeResult listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public NotifyWorkersResult notifyWorkers(NotifyWorkersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectAssignmentResult rejectAssignment(RejectAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectQualificationRequestResult rejectQualificationRequest(RejectQualificationRequestRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendBonusResult sendBonus(SendBonusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendTestEventNotificationResult sendTestEventNotification(SendTestEventNotificationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateExpirationForHITResult updateExpirationForHIT(UpdateExpirationForHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateHITReviewStatusResult updateHITReviewStatus(UpdateHITReviewStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateHITTypeOfHITResult updateHITTypeOfHIT(UpdateHITTypeOfHITRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNotificationSettingsResult updateNotificationSettings(UpdateNotificationSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQualificationTypeResult updateQualificationType(UpdateQualificationTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
