/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.MediaStream;

@SdkInternalApi
public class MediaStreamMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributes").build();
    private static final MarshallingInfo<Integer> CLOCKRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clockRate").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Integer> FMT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fmt").build();
    private static final MarshallingInfo<Integer> MEDIASTREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStreamId").build();
    private static final MarshallingInfo<String> MEDIASTREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStreamName").build();
    private static final MarshallingInfo<String> MEDIASTREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaStreamType").build();
    private static final MarshallingInfo<String> VIDEOFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoFormat").build();
    private static final MediaStreamMarshaller instance = new MediaStreamMarshaller();

    public static MediaStreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaStream mediaStream, ProtocolMarshaller protocolMarshaller) {
        if (mediaStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mediaStream.getAttributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getClockRate(), CLOCKRATE_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getFmt(), FMT_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getMediaStreamId(), MEDIASTREAMID_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getMediaStreamName(), MEDIASTREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getMediaStreamType(), MEDIASTREAMTYPE_BINDING);
            protocolMarshaller.marshall((Object)mediaStream.getVideoFormat(), VIDEOFORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

