/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.mediaconnect.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AddOutputRequest JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AddOutputRequestJsonUnmarshaller implements Unmarshaller<AddOutputRequest, JsonUnmarshallerContext> {

    public AddOutputRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        AddOutputRequest addOutputRequest = new AddOutputRequest();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("cidrAllowList", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setCidrAllowList(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setDescription(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("destination", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setDestination(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("encryption", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setEncryption(EncryptionJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("maxLatency", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setMaxLatency(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("mediaStreamOutputConfigurations", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setMediaStreamOutputConfigurations(new ListUnmarshaller<MediaStreamOutputConfigurationRequest>(
                            MediaStreamOutputConfigurationRequestJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("minLatency", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setMinLatency(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("port", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setPort(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("protocol", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setProtocol(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("remoteId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setRemoteId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("senderControlPort", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setSenderControlPort(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("smoothingLatency", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setSmoothingLatency(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("streamId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setStreamId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vpcInterfaceAttachment", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    addOutputRequest.setVpcInterfaceAttachment(VpcInterfaceAttachmentJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return addOutputRequest;
    }

    private static AddOutputRequestJsonUnmarshaller instance;

    public static AddOutputRequestJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AddOutputRequestJsonUnmarshaller();
        return instance;
    }
}
