/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.mediaconnect.model.BridgeSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddBridgeSourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String bridgeArn;
    private List<BridgeSource> sources;

    public void setBridgeArn(String bridgeArn) {
        this.bridgeArn = bridgeArn;
    }

    public String getBridgeArn() {
        return this.bridgeArn;
    }

    public AddBridgeSourcesResult withBridgeArn(String bridgeArn) {
        this.setBridgeArn(bridgeArn);
        return this;
    }

    public List<BridgeSource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<BridgeSource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<BridgeSource>(sources);
    }

    public AddBridgeSourcesResult withSources(BridgeSource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<BridgeSource>(sources.length));
        }
        for (BridgeSource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public AddBridgeSourcesResult withSources(Collection<BridgeSource> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBridgeArn() != null) {
            sb.append("BridgeArn: ").append(this.getBridgeArn()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeSourcesResult)) {
            return false;
        }
        AddBridgeSourcesResult other = (AddBridgeSourcesResult)obj;
        if (other.getBridgeArn() == null ^ this.getBridgeArn() == null) {
            return false;
        }
        if (other.getBridgeArn() != null && !other.getBridgeArn().equals(this.getBridgeArn())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBridgeArn() == null ? 0 : this.getBridgeArn().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public AddBridgeSourcesResult clone() {
        try {
            return (AddBridgeSourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

