/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.ContainerSettings;

@SdkInternalApi
public class ContainerSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CMFCSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cmfcSettings").build();
    private static final MarshallingInfo<String> CONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("container").build();
    private static final MarshallingInfo<StructuredPojo> F4VSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("f4vSettings").build();
    private static final MarshallingInfo<StructuredPojo> M2TSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m2tsSettings").build();
    private static final MarshallingInfo<StructuredPojo> M3U8SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("m3u8Settings").build();
    private static final MarshallingInfo<StructuredPojo> MOVSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("movSettings").build();
    private static final MarshallingInfo<StructuredPojo> MP4SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mp4Settings").build();
    private static final MarshallingInfo<StructuredPojo> MPDSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mpdSettings").build();
    private static final ContainerSettingsMarshaller instance = new ContainerSettingsMarshaller();

    public static ContainerSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ContainerSettings containerSettings, ProtocolMarshaller protocolMarshaller) {
        if (containerSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerSettings.getCmfcSettings(), CMFCSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getContainer(), CONTAINER_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getF4vSettings(), F4VSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getM2tsSettings(), M2TSSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getM3u8Settings(), M3U8SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getMovSettings(), MOVSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getMp4Settings(), MP4SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)containerSettings.getMpdSettings(), MPDSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

