/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import javax.annotation.Generated;

/**
 * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
 * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player configuration.
 * Max: Use the same value that you specify for Max bitrate in the video output, in bits per second. Average: Use the
 * calculated average bitrate of the encoded video output, in bits per second.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum DashIsoMpdManifestBandwidthType {

    AVERAGE("AVERAGE"),
    MAX("MAX");

    private String value;

    private DashIsoMpdManifestBandwidthType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return DashIsoMpdManifestBandwidthType corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static DashIsoMpdManifestBandwidthType fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (DashIsoMpdManifestBandwidthType enumEntry : DashIsoMpdManifestBandwidthType.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
