/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.mediaconvert.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * MpdSettingsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class MpdSettingsMarshaller {

    private static final MarshallingInfo<String> ACCESSIBILITYCAPTIONHINTS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accessibilityCaptionHints").build();
    private static final MarshallingInfo<String> AUDIODURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDuration").build();
    private static final MarshallingInfo<String> CAPTIONCONTAINERTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionContainerType").build();
    private static final MarshallingInfo<String> KLVMETADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("klvMetadata").build();
    private static final MarshallingInfo<String> MANIFESTMETADATASIGNALING_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestMetadataSignaling").build();
    private static final MarshallingInfo<String> SCTE35ESAM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Esam").build();
    private static final MarshallingInfo<String> SCTE35SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Source").build();
    private static final MarshallingInfo<String> TIMEDMETADATA_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadata").build();
    private static final MarshallingInfo<String> TIMEDMETADATABOXVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataBoxVersion").build();
    private static final MarshallingInfo<String> TIMEDMETADATASCHEMEIDURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataSchemeIdUri").build();
    private static final MarshallingInfo<String> TIMEDMETADATAVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataValue").build();

    private static final MpdSettingsMarshaller instance = new MpdSettingsMarshaller();

    public static MpdSettingsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MpdSettings mpdSettings, ProtocolMarshaller protocolMarshaller) {

        if (mpdSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(mpdSettings.getAccessibilityCaptionHints(), ACCESSIBILITYCAPTIONHINTS_BINDING);
            protocolMarshaller.marshall(mpdSettings.getAudioDuration(), AUDIODURATION_BINDING);
            protocolMarshaller.marshall(mpdSettings.getCaptionContainerType(), CAPTIONCONTAINERTYPE_BINDING);
            protocolMarshaller.marshall(mpdSettings.getKlvMetadata(), KLVMETADATA_BINDING);
            protocolMarshaller.marshall(mpdSettings.getManifestMetadataSignaling(), MANIFESTMETADATASIGNALING_BINDING);
            protocolMarshaller.marshall(mpdSettings.getScte35Esam(), SCTE35ESAM_BINDING);
            protocolMarshaller.marshall(mpdSettings.getScte35Source(), SCTE35SOURCE_BINDING);
            protocolMarshaller.marshall(mpdSettings.getTimedMetadata(), TIMEDMETADATA_BINDING);
            protocolMarshaller.marshall(mpdSettings.getTimedMetadataBoxVersion(), TIMEDMETADATABOXVERSION_BINDING);
            protocolMarshaller.marshall(mpdSettings.getTimedMetadataSchemeIdUri(), TIMEDMETADATASCHEMEIDURI_BINDING);
            protocolMarshaller.marshall(mpdSettings.getTimedMetadataValue(), TIMEDMETADATAVALUE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
