/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.InputTimecodeSource;
import com.amazonaws.services.mediaconvert.model.VideoOverlayInputClipping;
import com.amazonaws.services.mediaconvert.model.transform.VideoOverlayInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VideoOverlayInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileInput;
    private List<VideoOverlayInputClipping> inputClippings;
    private String timecodeSource;
    private String timecodeStart;

    public void setFileInput(String fileInput) {
        this.fileInput = fileInput;
    }

    public String getFileInput() {
        return this.fileInput;
    }

    public VideoOverlayInput withFileInput(String fileInput) {
        this.setFileInput(fileInput);
        return this;
    }

    public List<VideoOverlayInputClipping> getInputClippings() {
        return this.inputClippings;
    }

    public void setInputClippings(Collection<VideoOverlayInputClipping> inputClippings) {
        if (inputClippings == null) {
            this.inputClippings = null;
            return;
        }
        this.inputClippings = new ArrayList<VideoOverlayInputClipping>(inputClippings);
    }

    public VideoOverlayInput withInputClippings(VideoOverlayInputClipping ... inputClippings) {
        if (this.inputClippings == null) {
            this.setInputClippings(new ArrayList<VideoOverlayInputClipping>(inputClippings.length));
        }
        for (VideoOverlayInputClipping ele : inputClippings) {
            this.inputClippings.add(ele);
        }
        return this;
    }

    public VideoOverlayInput withInputClippings(Collection<VideoOverlayInputClipping> inputClippings) {
        this.setInputClippings(inputClippings);
        return this;
    }

    public void setTimecodeSource(String timecodeSource) {
        this.timecodeSource = timecodeSource;
    }

    public String getTimecodeSource() {
        return this.timecodeSource;
    }

    public VideoOverlayInput withTimecodeSource(String timecodeSource) {
        this.setTimecodeSource(timecodeSource);
        return this;
    }

    public VideoOverlayInput withTimecodeSource(InputTimecodeSource timecodeSource) {
        this.timecodeSource = timecodeSource.toString();
        return this;
    }

    public void setTimecodeStart(String timecodeStart) {
        this.timecodeStart = timecodeStart;
    }

    public String getTimecodeStart() {
        return this.timecodeStart;
    }

    public VideoOverlayInput withTimecodeStart(String timecodeStart) {
        this.setTimecodeStart(timecodeStart);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileInput() != null) {
            sb.append("FileInput: ").append(this.getFileInput()).append(",");
        }
        if (this.getInputClippings() != null) {
            sb.append("InputClippings: ").append(this.getInputClippings()).append(",");
        }
        if (this.getTimecodeSource() != null) {
            sb.append("TimecodeSource: ").append(this.getTimecodeSource()).append(",");
        }
        if (this.getTimecodeStart() != null) {
            sb.append("TimecodeStart: ").append(this.getTimecodeStart());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayInput)) {
            return false;
        }
        VideoOverlayInput other = (VideoOverlayInput)obj;
        if (other.getFileInput() == null ^ this.getFileInput() == null) {
            return false;
        }
        if (other.getFileInput() != null && !other.getFileInput().equals(this.getFileInput())) {
            return false;
        }
        if (other.getInputClippings() == null ^ this.getInputClippings() == null) {
            return false;
        }
        if (other.getInputClippings() != null && !other.getInputClippings().equals(this.getInputClippings())) {
            return false;
        }
        if (other.getTimecodeSource() == null ^ this.getTimecodeSource() == null) {
            return false;
        }
        if (other.getTimecodeSource() != null && !other.getTimecodeSource().equals(this.getTimecodeSource())) {
            return false;
        }
        if (other.getTimecodeStart() == null ^ this.getTimecodeStart() == null) {
            return false;
        }
        return other.getTimecodeStart() == null || other.getTimecodeStart().equals(this.getTimecodeStart());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileInput() == null ? 0 : this.getFileInput().hashCode());
        hashCode = 31 * hashCode + (this.getInputClippings() == null ? 0 : this.getInputClippings().hashCode());
        hashCode = 31 * hashCode + (this.getTimecodeSource() == null ? 0 : this.getTimecodeSource().hashCode());
        hashCode = 31 * hashCode + (this.getTimecodeStart() == null ? 0 : this.getTimecodeStart().hashCode());
        return hashCode;
    }

    public VideoOverlayInput clone() {
        try {
            return (VideoOverlayInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoOverlayInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

