/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import javax.annotation.Generated;

/**
 * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its current
 * value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest integer
 * value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (< 0.5). You
 * may need to use LEGACY if your client needs to ensure that the target duration is always longer than the actual
 * duration of the segment. Some older players may experience interrupted playback when the actual duration of a track
 * in a segment is longer than the target duration.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum CmafTargetDurationCompatibilityMode {

    LEGACY("LEGACY"),
    SPEC_COMPLIANT("SPEC_COMPLIANT");

    private String value;

    private CmafTargetDurationCompatibilityMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return CmafTargetDurationCompatibilityMode corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static CmafTargetDurationCompatibilityMode fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (CmafTargetDurationCompatibilityMode enumEntry : CmafTargetDurationCompatibilityMode.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
