/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * Settings related to your CMAF output package. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html.
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CmafGroupSettings" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CmafGroupSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     */
    private java.util.List<CmafAdditionalManifest> additionalManifests;
    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
     * streams are delivered from a different URL than the manifest file.
     */
    private String baseUrl;
    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     */
    private String clientCache;
    /** Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation. */
    private String codecSpecification;
    /**
     * Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as trick mode.
     * When specified, the I-frame only video segments are included within an additional AdaptationSet in your DASH
     * output manifest. To generate I-frame only video segments: Enter a name as a text string, up to 256 character long.
     * This name is appended to the end of this output group's base filename, that you specify as part of your
     * destination URI, and used for the I-frame only video segment files. You may also include format identifiers. For
     * more information, see:
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     * #using-settings-variables-with-streaming-outputs To not generate I-frame only video segments: Leave blank.
     */
    private String dashIFrameTrickPlayNameModifier;
    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     */
    private String dashManifestStyle;
    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    private String destination;
    /** Settings associated with the destination. Will vary based on the type of destination */
    private DestinationSettings destinationSettings;
    /** DRM settings. */
    private CmafEncryptionSettings encryption;
    /**
     * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults
     * to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this value strictly.
     */
    private Integer fragmentLength;
    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates a
     * child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     */
    private String imageBasedTrickPlay;
    /** Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED */
    private CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
    /** When set to GZIP, compresses HLS playlist. */
    private String manifestCompression;
    /** Indicates whether the output manifest should use floating point values for segment duration. */
    private String manifestDurationFormat;
    /** Minimum time of initially buffered media that is needed to ensure smooth playout. */
    private Integer minBufferTime;
    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment length,
     * in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify
     * a value for this setting, the encoder will combine any final segment that is shorter than the length that you
     * specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     */
    private Double minFinalSegmentLength;
    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     */
    private String mpdManifestBandwidthType;
    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     */
    private String mpdProfile;
    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial PTS
     * in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have
     * B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     */
    private String ptsOffsetHandlingForBFrames;
    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     */
    private String segmentControl;
    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 10. Related settings: Use Segment length control to specify whether the encoder enforces this value strictly. Use
     * Segment control to specify whether MediaConvert creates separate segment files or one content file that has
     * metadata to mark the segment boundaries.
     */
    private Integer segmentLength;
    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    private String segmentLengthControl;
    /** Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest. */
    private String streamInfResolution;
    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the
     * actual duration of the segment. Some older players may experience interrupted playback when the actual duration of
     * a track in a segment is longer than the target duration.
     */
    private String targetDurationCompatibilityMode;
    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     */
    private String videoCompositionOffsets;
    /** When set to ENABLED, a DASH MPD manifest will be generated for this output. */
    private String writeDashManifest;
    /** When set to ENABLED, an Apple HLS manifest will be generated for this output. */
    private String writeHlsManifest;
    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     */
    private String writeSegmentTimelineInRepresentation;

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     * 
     * @return By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
     *         for each CMAF output group in your job. These default manifests reference every output in the output
     *         group. To create additional top-level manifests that reference a subset of the outputs in the output
     *         group, specify a list of them here. For each additional manifest that you specify, the service creates
     *         one HLS manifest and one DASH manifest.
     */

    public java.util.List<CmafAdditionalManifest> getAdditionalManifests() {
        return additionalManifests;
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     * 
     * @param additionalManifests
     *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
     *        each CMAF output group in your job. These default manifests reference every output in the output group. To
     *        create additional top-level manifests that reference a subset of the outputs in the output group, specify
     *        a list of them here. For each additional manifest that you specify, the service creates one HLS manifest
     *        and one DASH manifest.
     */

    public void setAdditionalManifests(java.util.Collection<CmafAdditionalManifest> additionalManifests) {
        if (additionalManifests == null) {
            this.additionalManifests = null;
            return;
        }

        this.additionalManifests = new java.util.ArrayList<CmafAdditionalManifest>(additionalManifests);
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAdditionalManifests(java.util.Collection)} or {@link #withAdditionalManifests(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param additionalManifests
     *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
     *        each CMAF output group in your job. These default manifests reference every output in the output group. To
     *        create additional top-level manifests that reference a subset of the outputs in the output group, specify
     *        a list of them here. For each additional manifest that you specify, the service creates one HLS manifest
     *        and one DASH manifest.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withAdditionalManifests(CmafAdditionalManifest... additionalManifests) {
        if (this.additionalManifests == null) {
            setAdditionalManifests(new java.util.ArrayList<CmafAdditionalManifest>(additionalManifests.length));
        }
        for (CmafAdditionalManifest ele : additionalManifests) {
            this.additionalManifests.add(ele);
        }
        return this;
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     * 
     * @param additionalManifests
     *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
     *        each CMAF output group in your job. These default manifests reference every output in the output group. To
     *        create additional top-level manifests that reference a subset of the outputs in the output group, specify
     *        a list of them here. For each additional manifest that you specify, the service creates one HLS manifest
     *        and one DASH manifest.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withAdditionalManifests(java.util.Collection<CmafAdditionalManifest> additionalManifests) {
        setAdditionalManifests(additionalManifests);
        return this;
    }

    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
     * streams are delivered from a different URL than the manifest file.
     * 
     * @param baseUrl
     *        A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used
     *        if streams are delivered from a different URL than the manifest file.
     */

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
     * streams are delivered from a different URL than the manifest file.
     * 
     * @return A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used
     *         if streams are delivered from a different URL than the manifest file.
     */

    public String getBaseUrl() {
        return this.baseUrl;
    }

    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
     * streams are delivered from a different URL than the manifest file.
     * 
     * @param baseUrl
     *        A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used
     *        if streams are delivered from a different URL than the manifest file.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withBaseUrl(String baseUrl) {
        setBaseUrl(baseUrl);
        return this;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     * 
     * @param clientCache
     *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *        default value Enabled and control caching in your video distribution set up. For example, use the
     *        Cache-Control http header.
     * @see CmafClientCache
     */

    public void setClientCache(String clientCache) {
        this.clientCache = clientCache;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled and control caching in your video distribution set up. For example, use the
     *         Cache-Control http header.
     * @see CmafClientCache
     */

    public String getClientCache() {
        return this.clientCache;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     * 
     * @param clientCache
     *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *        default value Enabled and control caching in your video distribution set up. For example, use the
     *        Cache-Control http header.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafClientCache
     */

    public CmafGroupSettings withClientCache(String clientCache) {
        setClientCache(clientCache);
        return this;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     * 
     * @param clientCache
     *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *        default value Enabled and control caching in your video distribution set up. For example, use the
     *        Cache-Control http header.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafClientCache
     */

    public CmafGroupSettings withClientCache(CmafClientCache clientCache) {
        this.clientCache = clientCache.toString();
        return this;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * 
     * @param codecSpecification
     *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see CmafCodecSpecification
     */

    public void setCodecSpecification(String codecSpecification) {
        this.codecSpecification = codecSpecification;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see CmafCodecSpecification
     */

    public String getCodecSpecification() {
        return this.codecSpecification;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * 
     * @param codecSpecification
     *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafCodecSpecification
     */

    public CmafGroupSettings withCodecSpecification(String codecSpecification) {
        setCodecSpecification(codecSpecification);
        return this;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * 
     * @param codecSpecification
     *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafCodecSpecification
     */

    public CmafGroupSettings withCodecSpecification(CmafCodecSpecification codecSpecification) {
        this.codecSpecification = codecSpecification.toString();
        return this;
    }

    /**
     * Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as trick mode.
     * When specified, the I-frame only video segments are included within an additional AdaptationSet in your DASH
     * output manifest. To generate I-frame only video segments: Enter a name as a text string, up to 256 character long.
     * This name is appended to the end of this output group's base filename, that you specify as part of your
     * destination URI, and used for the I-frame only video segment files. You may also include format identifiers. For
     * more information, see:
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     * #using-settings-variables-with-streaming-outputs To not generate I-frame only video segments: Leave blank.
     * 
     * @param dashIFrameTrickPlayNameModifier
     *        Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as
     *        trick mode. When specified, the I-frame only video segments are included within an additional
     *        AdaptationSet in your DASH output manifest. To generate I-frame only video segments: Enter a name as a
     *        text string, up to 256 character long. This name is appended to the end of this output group's base
     *        filename, that you specify as part of your destination URI, and used for the I-frame only video segment
     *        files. You may also include format identifiers. For more information, see:
     *        https://docs.aws.amazon.com/mediaconvert
     *        /latest/ug/using-variables-in-your-job-settings.html#using-settings-variables-with-streaming-outputs To
     *        not generate I-frame only video segments: Leave blank.
     */

    public void setDashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
        this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
    }

    /**
     * Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as trick mode.
     * When specified, the I-frame only video segments are included within an additional AdaptationSet in your DASH
     * output manifest. To generate I-frame only video segments: Enter a name as a text string, up to 256 character long.
     * This name is appended to the end of this output group's base filename, that you specify as part of your
     * destination URI, and used for the I-frame only video segment files. You may also include format identifiers. For
     * more information, see:
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     * #using-settings-variables-with-streaming-outputs To not generate I-frame only video segments: Leave blank.
     * 
     * @return Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as
     *         trick mode. When specified, the I-frame only video segments are included within an additional
     *         AdaptationSet in your DASH output manifest. To generate I-frame only video segments: Enter a name as a
     *         text string, up to 256 character long. This name is appended to the end of this output group's base
     *         filename, that you specify as part of your destination URI, and used for the I-frame only video segment
     *         files. You may also include format identifiers. For more information, see:
     *         https://docs.aws.amazon.com/mediaconvert
     *         /latest/ug/using-variables-in-your-job-settings.html#using-settings-variables-with-streaming-outputs To
     *         not generate I-frame only video segments: Leave blank.
     */

    public String getDashIFrameTrickPlayNameModifier() {
        return this.dashIFrameTrickPlayNameModifier;
    }

    /**
     * Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as trick mode.
     * When specified, the I-frame only video segments are included within an additional AdaptationSet in your DASH
     * output manifest. To generate I-frame only video segments: Enter a name as a text string, up to 256 character long.
     * This name is appended to the end of this output group's base filename, that you specify as part of your
     * destination URI, and used for the I-frame only video segment files. You may also include format identifiers. For
     * more information, see:
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     * #using-settings-variables-with-streaming-outputs To not generate I-frame only video segments: Leave blank.
     * 
     * @param dashIFrameTrickPlayNameModifier
     *        Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as
     *        trick mode. When specified, the I-frame only video segments are included within an additional
     *        AdaptationSet in your DASH output manifest. To generate I-frame only video segments: Enter a name as a
     *        text string, up to 256 character long. This name is appended to the end of this output group's base
     *        filename, that you specify as part of your destination URI, and used for the I-frame only video segment
     *        files. You may also include format identifiers. For more information, see:
     *        https://docs.aws.amazon.com/mediaconvert
     *        /latest/ug/using-variables-in-your-job-settings.html#using-settings-variables-with-streaming-outputs To
     *        not generate I-frame only video segments: Leave blank.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withDashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
        setDashIFrameTrickPlayNameModifier(dashIFrameTrickPlayNameModifier);
        return this;
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * 
     * @param dashManifestStyle
     *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *        in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *        video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *        Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *        output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @see DashManifestStyle
     */

    public void setDashManifestStyle(String dashManifestStyle) {
        this.dashManifestStyle = dashManifestStyle;
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * 
     * @return Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *         in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *         video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *         Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *         output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @see DashManifestStyle
     */

    public String getDashManifestStyle() {
        return this.dashManifestStyle;
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * 
     * @param dashManifestStyle
     *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *        in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *        video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *        Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *        output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DashManifestStyle
     */

    public CmafGroupSettings withDashManifestStyle(String dashManifestStyle) {
        setDashManifestStyle(dashManifestStyle);
        return this;
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * 
     * @param dashManifestStyle
     *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *        in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *        video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *        Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *        output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DashManifestStyle
     */

    public CmafGroupSettings withDashManifestStyle(DashManifestStyle dashManifestStyle) {
        this.dashManifestStyle = dashManifestStyle.toString();
        return this;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @param destination
     *        Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     *        identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     *        input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */

    public void setDestination(String destination) {
        this.destination = destination;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination to specify the S3 output location and the output filename base. Destination accepts
     *         format identifiers. If you do not specify the base filename in the URI, the service will use the filename
     *         of the input file. If your job has multiple inputs, the service uses the filename of the first input
     *         file.
     */

    public String getDestination() {
        return this.destination;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @param destination
     *        Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     *        identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     *        input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withDestination(String destination) {
        setDestination(destination);
        return this;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @param destinationSettings
     *        Settings associated with the destination. Will vary based on the type of destination
     */

    public void setDestinationSettings(DestinationSettings destinationSettings) {
        this.destinationSettings = destinationSettings;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */

    public DestinationSettings getDestinationSettings() {
        return this.destinationSettings;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @param destinationSettings
     *        Settings associated with the destination. Will vary based on the type of destination
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withDestinationSettings(DestinationSettings destinationSettings) {
        setDestinationSettings(destinationSettings);
        return this;
    }

    /**
     * DRM settings.
     * 
     * @param encryption
     *        DRM settings.
     */

    public void setEncryption(CmafEncryptionSettings encryption) {
        this.encryption = encryption;
    }

    /**
     * DRM settings.
     * 
     * @return DRM settings.
     */

    public CmafEncryptionSettings getEncryption() {
        return this.encryption;
    }

    /**
     * DRM settings.
     * 
     * @param encryption
     *        DRM settings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withEncryption(CmafEncryptionSettings encryption) {
        setEncryption(encryption);
        return this;
    }

    /**
     * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults
     * to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this value strictly.
     * 
     * @param fragmentLength
     *        Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert
     *        defaults to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this
     *        value strictly.
     */

    public void setFragmentLength(Integer fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    /**
     * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults
     * to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this value strictly.
     * 
     * @return Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert
     *         defaults to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this
     *         value strictly.
     */

    public Integer getFragmentLength() {
        return this.fragmentLength;
    }

    /**
     * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults
     * to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this value strictly.
     * 
     * @param fragmentLength
     *        Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert
     *        defaults to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this
     *        value strictly.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withFragmentLength(Integer fragmentLength) {
        setFragmentLength(fragmentLength);
        return this;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates a
     * child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * 
     * @param imageBasedTrickPlay
     *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *        generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS manifest,
     *        MediaConvert creates a child manifest for each set of images that you generate and adds corresponding
     *        entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds an entry in the
     *        .mpd manifest for each set of images that you generate. A common application for these images is Roku
     *        trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
     *        compatible with this Roku specification:
     *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see CmafImageBasedTrickPlay
     */

    public void setImageBasedTrickPlay(String imageBasedTrickPlay) {
        this.imageBasedTrickPlay = imageBasedTrickPlay;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates a
     * child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *         generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *         generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS
     *         manifest, MediaConvert creates a child manifest for each set of images that you generate and adds
     *         corresponding entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds an
     *         entry in the .mpd manifest for each set of images that you generate. A common application for these
     *         images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this
     *         feature are compatible with this Roku specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see CmafImageBasedTrickPlay
     */

    public String getImageBasedTrickPlay() {
        return this.imageBasedTrickPlay;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates a
     * child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * 
     * @param imageBasedTrickPlay
     *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *        generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS manifest,
     *        MediaConvert creates a child manifest for each set of images that you generate and adds corresponding
     *        entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds an entry in the
     *        .mpd manifest for each set of images that you generate. A common application for these images is Roku
     *        trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
     *        compatible with this Roku specification:
     *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafImageBasedTrickPlay
     */

    public CmafGroupSettings withImageBasedTrickPlay(String imageBasedTrickPlay) {
        setImageBasedTrickPlay(imageBasedTrickPlay);
        return this;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates a
     * child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * 
     * @param imageBasedTrickPlay
     *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *        generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS manifest,
     *        MediaConvert creates a child manifest for each set of images that you generate and adds corresponding
     *        entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds an entry in the
     *        .mpd manifest for each set of images that you generate. A common application for these images is Roku
     *        trick mode. The thumbnails and full-frame images that MediaConvert creates with this feature are
     *        compatible with this Roku specification:
     *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafImageBasedTrickPlay
     */

    public CmafGroupSettings withImageBasedTrickPlay(CmafImageBasedTrickPlay imageBasedTrickPlay) {
        this.imageBasedTrickPlay = imageBasedTrickPlay.toString();
        return this;
    }

    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * 
     * @param imageBasedTrickPlaySettings
     *        Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */

    public void setImageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
        this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
    }

    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * 
     * @return Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */

    public CmafImageBasedTrickPlaySettings getImageBasedTrickPlaySettings() {
        return this.imageBasedTrickPlaySettings;
    }

    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * 
     * @param imageBasedTrickPlaySettings
     *        Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withImageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
        setImageBasedTrickPlaySettings(imageBasedTrickPlaySettings);
        return this;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * 
     * @param manifestCompression
     *        When set to GZIP, compresses HLS playlist.
     * @see CmafManifestCompression
     */

    public void setManifestCompression(String manifestCompression) {
        this.manifestCompression = manifestCompression;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see CmafManifestCompression
     */

    public String getManifestCompression() {
        return this.manifestCompression;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * 
     * @param manifestCompression
     *        When set to GZIP, compresses HLS playlist.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafManifestCompression
     */

    public CmafGroupSettings withManifestCompression(String manifestCompression) {
        setManifestCompression(manifestCompression);
        return this;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * 
     * @param manifestCompression
     *        When set to GZIP, compresses HLS playlist.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafManifestCompression
     */

    public CmafGroupSettings withManifestCompression(CmafManifestCompression manifestCompression) {
        this.manifestCompression = manifestCompression.toString();
        return this;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * 
     * @param manifestDurationFormat
     *        Indicates whether the output manifest should use floating point values for segment duration.
     * @see CmafManifestDurationFormat
     */

    public void setManifestDurationFormat(String manifestDurationFormat) {
        this.manifestDurationFormat = manifestDurationFormat;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see CmafManifestDurationFormat
     */

    public String getManifestDurationFormat() {
        return this.manifestDurationFormat;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * 
     * @param manifestDurationFormat
     *        Indicates whether the output manifest should use floating point values for segment duration.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafManifestDurationFormat
     */

    public CmafGroupSettings withManifestDurationFormat(String manifestDurationFormat) {
        setManifestDurationFormat(manifestDurationFormat);
        return this;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * 
     * @param manifestDurationFormat
     *        Indicates whether the output manifest should use floating point values for segment duration.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafManifestDurationFormat
     */

    public CmafGroupSettings withManifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
        this.manifestDurationFormat = manifestDurationFormat.toString();
        return this;
    }

    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     * 
     * @param minBufferTime
     *        Minimum time of initially buffered media that is needed to ensure smooth playout.
     */

    public void setMinBufferTime(Integer minBufferTime) {
        this.minBufferTime = minBufferTime;
    }

    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     * 
     * @return Minimum time of initially buffered media that is needed to ensure smooth playout.
     */

    public Integer getMinBufferTime() {
        return this.minBufferTime;
    }

    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     * 
     * @param minBufferTime
     *        Minimum time of initially buffered media that is needed to ensure smooth playout.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withMinBufferTime(Integer minBufferTime) {
        setMinBufferTime(minBufferTime);
        return this;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment length,
     * in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify
     * a value for this setting, the encoder will combine any final segment that is shorter than the length that you
     * specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @param minFinalSegmentLength
     *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *        play back the end of your video asset. If you know that player devices are hanging on the final segment of
     *        your video because the length of your final segment is too short, use this setting to specify a minimum
     *        final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your
     *        segment length. When you specify a value for this setting, the encoder will combine any final segment that
     *        is shorter than the length that you specify with the previous segment. For example, your segment length is
     *        3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the
     *        minimum final segment length to 1, your final segment is 3.5 seconds.
     */

    public void setMinFinalSegmentLength(Double minFinalSegmentLength) {
        this.minFinalSegmentLength = minFinalSegmentLength;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment length,
     * in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify
     * a value for this setting, the encoder will combine any final segment that is shorter than the length that you
     * specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @return Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *         play back the end of your video asset. If you know that player devices are hanging on the final segment
     *         of your video because the length of your final segment is too short, use this setting to specify a
     *         minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than
     *         your segment length. When you specify a value for this setting, the encoder will combine any final
     *         segment that is shorter than the length that you specify with the previous segment. For example, your
     *         segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length;
     *         when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */

    public Double getMinFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment length,
     * in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you specify
     * a value for this setting, the encoder will combine any final segment that is shorter than the length that you
     * specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @param minFinalSegmentLength
     *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *        play back the end of your video asset. If you know that player devices are hanging on the final segment of
     *        your video because the length of your final segment is too short, use this setting to specify a minimum
     *        final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your
     *        segment length. When you specify a value for this setting, the encoder will combine any final segment that
     *        is shorter than the length that you specify with the previous segment. For example, your segment length is
     *        3 seconds and your final segment is .5 seconds without a minimum final segment length; when you set the
     *        minimum final segment length to 1, your final segment is 3.5 seconds.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withMinFinalSegmentLength(Double minFinalSegmentLength) {
        setMinFinalSegmentLength(minFinalSegmentLength);
        return this;
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * 
     * @param mpdManifestBandwidthType
     *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *        bits per second.
     * @see CmafMpdManifestBandwidthType
     */

    public void setMpdManifestBandwidthType(String mpdManifestBandwidthType) {
        this.mpdManifestBandwidthType = mpdManifestBandwidthType;
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * 
     * @return Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *         manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *         downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *         output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *         bits per second.
     * @see CmafMpdManifestBandwidthType
     */

    public String getMpdManifestBandwidthType() {
        return this.mpdManifestBandwidthType;
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * 
     * @param mpdManifestBandwidthType
     *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *        bits per second.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafMpdManifestBandwidthType
     */

    public CmafGroupSettings withMpdManifestBandwidthType(String mpdManifestBandwidthType) {
        setMpdManifestBandwidthType(mpdManifestBandwidthType);
        return this;
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * 
     * @param mpdManifestBandwidthType
     *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *        bits per second.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafMpdManifestBandwidthType
     */

    public CmafGroupSettings withMpdManifestBandwidthType(CmafMpdManifestBandwidthType mpdManifestBandwidthType) {
        this.mpdManifestBandwidthType = mpdManifestBandwidthType.toString();
        return this;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * 
     * @param mpdProfile
     *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *        urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *        signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *        set the output group setting Segment control to Single file.
     * @see CmafMpdProfile
     */

    public void setMpdProfile(String mpdProfile) {
        this.mpdProfile = mpdProfile;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *         urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *         signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *         set the output group setting Segment control to Single file.
     * @see CmafMpdProfile
     */

    public String getMpdProfile() {
        return this.mpdProfile;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * 
     * @param mpdProfile
     *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *        urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *        signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *        set the output group setting Segment control to Single file.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafMpdProfile
     */

    public CmafGroupSettings withMpdProfile(String mpdProfile) {
        setMpdProfile(mpdProfile);
        return this;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * 
     * @param mpdProfile
     *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *        urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *        signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *        set the output group setting Segment control to Single file.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafMpdProfile
     */

    public CmafGroupSettings withMpdProfile(CmafMpdProfile mpdProfile) {
        this.mpdProfile = mpdProfile.toString();
        return this;
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial PTS
     * in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have
     * B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * 
     * @param ptsOffsetHandlingForBFrames
     *        Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *        time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *        PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert
     *        to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert
     *        ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the
     *        manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero
     *        regardless of your choice here.
     * @see CmafPtsOffsetHandlingForBFrames
     */

    public void setPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
        this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial PTS
     * in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have
     * B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * 
     * @return Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *         time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *         PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want
     *         MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have
     *         MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero
     *         in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at
     *         zero regardless of your choice here.
     * @see CmafPtsOffsetHandlingForBFrames
     */

    public String getPtsOffsetHandlingForBFrames() {
        return this.ptsOffsetHandlingForBFrames;
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial PTS
     * in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have
     * B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * 
     * @param ptsOffsetHandlingForBFrames
     *        Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *        time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *        PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert
     *        to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert
     *        ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the
     *        manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero
     *        regardless of your choice here.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafPtsOffsetHandlingForBFrames
     */

    public CmafGroupSettings withPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
        setPtsOffsetHandlingForBFrames(ptsOffsetHandlingForBFrames);
        return this;
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial PTS
     * in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't have
     * B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * 
     * @param ptsOffsetHandlingForBFrames
     *        Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *        time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *        PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert
     *        to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert
     *        ignore the initial PTS in the video stream and instead write the initial time stamp as zero in the
     *        manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at zero
     *        regardless of your choice here.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafPtsOffsetHandlingForBFrames
     */

    public CmafGroupSettings withPtsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames) {
        this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames.toString();
        return this;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * 
     * @param segmentControl
     *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see CmafSegmentControl
     */

    public void setSegmentControl(String segmentControl) {
        this.segmentControl = segmentControl;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see CmafSegmentControl
     */

    public String getSegmentControl() {
        return this.segmentControl;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * 
     * @param segmentControl
     *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafSegmentControl
     */

    public CmafGroupSettings withSegmentControl(String segmentControl) {
        setSegmentControl(segmentControl);
        return this;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * 
     * @param segmentControl
     *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafSegmentControl
     */

    public CmafGroupSettings withSegmentControl(CmafSegmentControl segmentControl) {
        this.segmentControl = segmentControl.toString();
        return this;
    }

    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 10. Related settings: Use Segment length control to specify whether the encoder enforces this value strictly. Use
     * Segment control to specify whether MediaConvert creates separate segment files or one content file that has
     * metadata to mark the segment boundaries.
     * 
     * @param segmentLength
     *        Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
     *        defaults to 10. Related settings: Use Segment length control to specify whether the encoder enforces this
     *        value strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one
     *        content file that has metadata to mark the segment boundaries.
     */

    public void setSegmentLength(Integer segmentLength) {
        this.segmentLength = segmentLength;
    }

    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 10. Related settings: Use Segment length control to specify whether the encoder enforces this value strictly. Use
     * Segment control to specify whether MediaConvert creates separate segment files or one content file that has
     * metadata to mark the segment boundaries.
     * 
     * @return Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
     *         defaults to 10. Related settings: Use Segment length control to specify whether the encoder enforces this
     *         value strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one
     *         content file that has metadata to mark the segment boundaries.
     */

    public Integer getSegmentLength() {
        return this.segmentLength;
    }

    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 10. Related settings: Use Segment length control to specify whether the encoder enforces this value strictly. Use
     * Segment control to specify whether MediaConvert creates separate segment files or one content file that has
     * metadata to mark the segment boundaries.
     * 
     * @param segmentLength
     *        Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
     *        defaults to 10. Related settings: Use Segment length control to specify whether the encoder enforces this
     *        value strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one
     *        content file that has metadata to mark the segment boundaries.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CmafGroupSettings withSegmentLength(Integer segmentLength) {
        setSegmentLength(segmentLength);
        return this;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param segmentLengthControl
     *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see CmafSegmentLengthControl
     */

    public void setSegmentLengthControl(String segmentLengthControl) {
        this.segmentLengthControl = segmentLengthControl;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see CmafSegmentLengthControl
     */

    public String getSegmentLengthControl() {
        return this.segmentLengthControl;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param segmentLengthControl
     *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafSegmentLengthControl
     */

    public CmafGroupSettings withSegmentLengthControl(String segmentLengthControl) {
        setSegmentLengthControl(segmentLengthControl);
        return this;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param segmentLengthControl
     *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafSegmentLengthControl
     */

    public CmafGroupSettings withSegmentLengthControl(CmafSegmentLengthControl segmentLengthControl) {
        this.segmentLengthControl = segmentLengthControl.toString();
        return this;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * 
     * @param streamInfResolution
     *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see CmafStreamInfResolution
     */

    public void setStreamInfResolution(String streamInfResolution) {
        this.streamInfResolution = streamInfResolution;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see CmafStreamInfResolution
     */

    public String getStreamInfResolution() {
        return this.streamInfResolution;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * 
     * @param streamInfResolution
     *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafStreamInfResolution
     */

    public CmafGroupSettings withStreamInfResolution(String streamInfResolution) {
        setStreamInfResolution(streamInfResolution);
        return this;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * 
     * @param streamInfResolution
     *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafStreamInfResolution
     */

    public CmafGroupSettings withStreamInfResolution(CmafStreamInfResolution streamInfResolution) {
        this.streamInfResolution = streamInfResolution.toString();
        return this;
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the
     * actual duration of the segment. Some older players may experience interrupted playback when the actual duration of
     * a track in a segment is longer than the target duration.
     * 
     * @param targetDurationCompatibilityMode
     *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *        its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *        the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *        if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *        duration is always longer than the actual duration of the segment. Some older players may experience
     *        interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @see CmafTargetDurationCompatibilityMode
     */

    public void setTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
        this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the
     * actual duration of the segment. Some older players may experience interrupted playback when the actual duration of
     * a track in a segment is longer than the target duration.
     * 
     * @return When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *         its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *         the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *         if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *         duration is always longer than the actual duration of the segment. Some older players may experience
     *         interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @see CmafTargetDurationCompatibilityMode
     */

    public String getTargetDurationCompatibilityMode() {
        return this.targetDurationCompatibilityMode;
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the
     * actual duration of the segment. Some older players may experience interrupted playback when the actual duration of
     * a track in a segment is longer than the target duration.
     * 
     * @param targetDurationCompatibilityMode
     *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *        its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *        the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *        if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *        duration is always longer than the actual duration of the segment. Some older players may experience
     *        interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafTargetDurationCompatibilityMode
     */

    public CmafGroupSettings withTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
        setTargetDurationCompatibilityMode(targetDurationCompatibilityMode);
        return this;
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than the
     * actual duration of the segment. Some older players may experience interrupted playback when the actual duration of
     * a track in a segment is longer than the target duration.
     * 
     * @param targetDurationCompatibilityMode
     *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *        its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *        the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *        if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *        duration is always longer than the actual duration of the segment. Some older players may experience
     *        interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafTargetDurationCompatibilityMode
     */

    public CmafGroupSettings withTargetDurationCompatibilityMode(CmafTargetDurationCompatibilityMode targetDurationCompatibilityMode) {
        this.targetDurationCompatibilityMode = targetDurationCompatibilityMode.toString();
        return this;
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * 
     * @param videoCompositionOffsets
     *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *        may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *        strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *        time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @see CmafVideoCompositionOffsets
     */

    public void setVideoCompositionOffsets(String videoCompositionOffsets) {
        this.videoCompositionOffsets = videoCompositionOffsets;
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * 
     * @return Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *         compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *         may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *         strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *         time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @see CmafVideoCompositionOffsets
     */

    public String getVideoCompositionOffsets() {
        return this.videoCompositionOffsets;
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * 
     * @param videoCompositionOffsets
     *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *        may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *        strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *        time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafVideoCompositionOffsets
     */

    public CmafGroupSettings withVideoCompositionOffsets(String videoCompositionOffsets) {
        setVideoCompositionOffsets(videoCompositionOffsets);
        return this;
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * 
     * @param videoCompositionOffsets
     *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *        may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *        strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *        time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafVideoCompositionOffsets
     */

    public CmafGroupSettings withVideoCompositionOffsets(CmafVideoCompositionOffsets videoCompositionOffsets) {
        this.videoCompositionOffsets = videoCompositionOffsets.toString();
        return this;
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * 
     * @param writeDashManifest
     *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @see CmafWriteDASHManifest
     */

    public void setWriteDashManifest(String writeDashManifest) {
        this.writeDashManifest = writeDashManifest;
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * 
     * @return When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @see CmafWriteDASHManifest
     */

    public String getWriteDashManifest() {
        return this.writeDashManifest;
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * 
     * @param writeDashManifest
     *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafWriteDASHManifest
     */

    public CmafGroupSettings withWriteDashManifest(String writeDashManifest) {
        setWriteDashManifest(writeDashManifest);
        return this;
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * 
     * @param writeDashManifest
     *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafWriteDASHManifest
     */

    public CmafGroupSettings withWriteDashManifest(CmafWriteDASHManifest writeDashManifest) {
        this.writeDashManifest = writeDashManifest.toString();
        return this;
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * 
     * @param writeHlsManifest
     *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @see CmafWriteHLSManifest
     */

    public void setWriteHlsManifest(String writeHlsManifest) {
        this.writeHlsManifest = writeHlsManifest;
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * 
     * @return When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @see CmafWriteHLSManifest
     */

    public String getWriteHlsManifest() {
        return this.writeHlsManifest;
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * 
     * @param writeHlsManifest
     *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafWriteHLSManifest
     */

    public CmafGroupSettings withWriteHlsManifest(String writeHlsManifest) {
        setWriteHlsManifest(writeHlsManifest);
        return this;
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * 
     * @param writeHlsManifest
     *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafWriteHLSManifest
     */

    public CmafGroupSettings withWriteHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
        this.writeHlsManifest = writeHlsManifest.toString();
        return this;
    }

    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     * 
     * @param writeSegmentTimelineInRepresentation
     *        When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
     *        durations. The segment duration information appears inside the SegmentTimeline element, inside
     *        SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
     *        your DASH manifest are approximate. The segment duration information appears in the duration attribute of
     *        the SegmentTemplate element.
     * @see CmafWriteSegmentTimelineInRepresentation
     */

    public void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
        this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
    }

    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     * 
     * @return When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
     *         durations. The segment duration information appears inside the SegmentTimeline element, inside
     *         SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
     *         your DASH manifest are approximate. The segment duration information appears in the duration attribute of
     *         the SegmentTemplate element.
     * @see CmafWriteSegmentTimelineInRepresentation
     */

    public String getWriteSegmentTimelineInRepresentation() {
        return this.writeSegmentTimelineInRepresentation;
    }

    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     * 
     * @param writeSegmentTimelineInRepresentation
     *        When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
     *        durations. The segment duration information appears inside the SegmentTimeline element, inside
     *        SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
     *        your DASH manifest are approximate. The segment duration information appears in the duration attribute of
     *        the SegmentTemplate element.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafWriteSegmentTimelineInRepresentation
     */

    public CmafGroupSettings withWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
        setWriteSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation);
        return this;
    }

    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     * 
     * @param writeSegmentTimelineInRepresentation
     *        When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
     *        durations. The segment duration information appears inside the SegmentTimeline element, inside
     *        SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
     *        your DASH manifest are approximate. The segment duration information appears in the duration attribute of
     *        the SegmentTemplate element.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CmafWriteSegmentTimelineInRepresentation
     */

    public CmafGroupSettings withWriteSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
        this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAdditionalManifests() != null)
            sb.append("AdditionalManifests: ").append(getAdditionalManifests()).append(",");
        if (getBaseUrl() != null)
            sb.append("BaseUrl: ").append(getBaseUrl()).append(",");
        if (getClientCache() != null)
            sb.append("ClientCache: ").append(getClientCache()).append(",");
        if (getCodecSpecification() != null)
            sb.append("CodecSpecification: ").append(getCodecSpecification()).append(",");
        if (getDashIFrameTrickPlayNameModifier() != null)
            sb.append("DashIFrameTrickPlayNameModifier: ").append(getDashIFrameTrickPlayNameModifier()).append(",");
        if (getDashManifestStyle() != null)
            sb.append("DashManifestStyle: ").append(getDashManifestStyle()).append(",");
        if (getDestination() != null)
            sb.append("Destination: ").append(getDestination()).append(",");
        if (getDestinationSettings() != null)
            sb.append("DestinationSettings: ").append(getDestinationSettings()).append(",");
        if (getEncryption() != null)
            sb.append("Encryption: ").append(getEncryption()).append(",");
        if (getFragmentLength() != null)
            sb.append("FragmentLength: ").append(getFragmentLength()).append(",");
        if (getImageBasedTrickPlay() != null)
            sb.append("ImageBasedTrickPlay: ").append(getImageBasedTrickPlay()).append(",");
        if (getImageBasedTrickPlaySettings() != null)
            sb.append("ImageBasedTrickPlaySettings: ").append(getImageBasedTrickPlaySettings()).append(",");
        if (getManifestCompression() != null)
            sb.append("ManifestCompression: ").append(getManifestCompression()).append(",");
        if (getManifestDurationFormat() != null)
            sb.append("ManifestDurationFormat: ").append(getManifestDurationFormat()).append(",");
        if (getMinBufferTime() != null)
            sb.append("MinBufferTime: ").append(getMinBufferTime()).append(",");
        if (getMinFinalSegmentLength() != null)
            sb.append("MinFinalSegmentLength: ").append(getMinFinalSegmentLength()).append(",");
        if (getMpdManifestBandwidthType() != null)
            sb.append("MpdManifestBandwidthType: ").append(getMpdManifestBandwidthType()).append(",");
        if (getMpdProfile() != null)
            sb.append("MpdProfile: ").append(getMpdProfile()).append(",");
        if (getPtsOffsetHandlingForBFrames() != null)
            sb.append("PtsOffsetHandlingForBFrames: ").append(getPtsOffsetHandlingForBFrames()).append(",");
        if (getSegmentControl() != null)
            sb.append("SegmentControl: ").append(getSegmentControl()).append(",");
        if (getSegmentLength() != null)
            sb.append("SegmentLength: ").append(getSegmentLength()).append(",");
        if (getSegmentLengthControl() != null)
            sb.append("SegmentLengthControl: ").append(getSegmentLengthControl()).append(",");
        if (getStreamInfResolution() != null)
            sb.append("StreamInfResolution: ").append(getStreamInfResolution()).append(",");
        if (getTargetDurationCompatibilityMode() != null)
            sb.append("TargetDurationCompatibilityMode: ").append(getTargetDurationCompatibilityMode()).append(",");
        if (getVideoCompositionOffsets() != null)
            sb.append("VideoCompositionOffsets: ").append(getVideoCompositionOffsets()).append(",");
        if (getWriteDashManifest() != null)
            sb.append("WriteDashManifest: ").append(getWriteDashManifest()).append(",");
        if (getWriteHlsManifest() != null)
            sb.append("WriteHlsManifest: ").append(getWriteHlsManifest()).append(",");
        if (getWriteSegmentTimelineInRepresentation() != null)
            sb.append("WriteSegmentTimelineInRepresentation: ").append(getWriteSegmentTimelineInRepresentation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CmafGroupSettings == false)
            return false;
        CmafGroupSettings other = (CmafGroupSettings) obj;
        if (other.getAdditionalManifests() == null ^ this.getAdditionalManifests() == null)
            return false;
        if (other.getAdditionalManifests() != null && other.getAdditionalManifests().equals(this.getAdditionalManifests()) == false)
            return false;
        if (other.getBaseUrl() == null ^ this.getBaseUrl() == null)
            return false;
        if (other.getBaseUrl() != null && other.getBaseUrl().equals(this.getBaseUrl()) == false)
            return false;
        if (other.getClientCache() == null ^ this.getClientCache() == null)
            return false;
        if (other.getClientCache() != null && other.getClientCache().equals(this.getClientCache()) == false)
            return false;
        if (other.getCodecSpecification() == null ^ this.getCodecSpecification() == null)
            return false;
        if (other.getCodecSpecification() != null && other.getCodecSpecification().equals(this.getCodecSpecification()) == false)
            return false;
        if (other.getDashIFrameTrickPlayNameModifier() == null ^ this.getDashIFrameTrickPlayNameModifier() == null)
            return false;
        if (other.getDashIFrameTrickPlayNameModifier() != null
                && other.getDashIFrameTrickPlayNameModifier().equals(this.getDashIFrameTrickPlayNameModifier()) == false)
            return false;
        if (other.getDashManifestStyle() == null ^ this.getDashManifestStyle() == null)
            return false;
        if (other.getDashManifestStyle() != null && other.getDashManifestStyle().equals(this.getDashManifestStyle()) == false)
            return false;
        if (other.getDestination() == null ^ this.getDestination() == null)
            return false;
        if (other.getDestination() != null && other.getDestination().equals(this.getDestination()) == false)
            return false;
        if (other.getDestinationSettings() == null ^ this.getDestinationSettings() == null)
            return false;
        if (other.getDestinationSettings() != null && other.getDestinationSettings().equals(this.getDestinationSettings()) == false)
            return false;
        if (other.getEncryption() == null ^ this.getEncryption() == null)
            return false;
        if (other.getEncryption() != null && other.getEncryption().equals(this.getEncryption()) == false)
            return false;
        if (other.getFragmentLength() == null ^ this.getFragmentLength() == null)
            return false;
        if (other.getFragmentLength() != null && other.getFragmentLength().equals(this.getFragmentLength()) == false)
            return false;
        if (other.getImageBasedTrickPlay() == null ^ this.getImageBasedTrickPlay() == null)
            return false;
        if (other.getImageBasedTrickPlay() != null && other.getImageBasedTrickPlay().equals(this.getImageBasedTrickPlay()) == false)
            return false;
        if (other.getImageBasedTrickPlaySettings() == null ^ this.getImageBasedTrickPlaySettings() == null)
            return false;
        if (other.getImageBasedTrickPlaySettings() != null && other.getImageBasedTrickPlaySettings().equals(this.getImageBasedTrickPlaySettings()) == false)
            return false;
        if (other.getManifestCompression() == null ^ this.getManifestCompression() == null)
            return false;
        if (other.getManifestCompression() != null && other.getManifestCompression().equals(this.getManifestCompression()) == false)
            return false;
        if (other.getManifestDurationFormat() == null ^ this.getManifestDurationFormat() == null)
            return false;
        if (other.getManifestDurationFormat() != null && other.getManifestDurationFormat().equals(this.getManifestDurationFormat()) == false)
            return false;
        if (other.getMinBufferTime() == null ^ this.getMinBufferTime() == null)
            return false;
        if (other.getMinBufferTime() != null && other.getMinBufferTime().equals(this.getMinBufferTime()) == false)
            return false;
        if (other.getMinFinalSegmentLength() == null ^ this.getMinFinalSegmentLength() == null)
            return false;
        if (other.getMinFinalSegmentLength() != null && other.getMinFinalSegmentLength().equals(this.getMinFinalSegmentLength()) == false)
            return false;
        if (other.getMpdManifestBandwidthType() == null ^ this.getMpdManifestBandwidthType() == null)
            return false;
        if (other.getMpdManifestBandwidthType() != null && other.getMpdManifestBandwidthType().equals(this.getMpdManifestBandwidthType()) == false)
            return false;
        if (other.getMpdProfile() == null ^ this.getMpdProfile() == null)
            return false;
        if (other.getMpdProfile() != null && other.getMpdProfile().equals(this.getMpdProfile()) == false)
            return false;
        if (other.getPtsOffsetHandlingForBFrames() == null ^ this.getPtsOffsetHandlingForBFrames() == null)
            return false;
        if (other.getPtsOffsetHandlingForBFrames() != null && other.getPtsOffsetHandlingForBFrames().equals(this.getPtsOffsetHandlingForBFrames()) == false)
            return false;
        if (other.getSegmentControl() == null ^ this.getSegmentControl() == null)
            return false;
        if (other.getSegmentControl() != null && other.getSegmentControl().equals(this.getSegmentControl()) == false)
            return false;
        if (other.getSegmentLength() == null ^ this.getSegmentLength() == null)
            return false;
        if (other.getSegmentLength() != null && other.getSegmentLength().equals(this.getSegmentLength()) == false)
            return false;
        if (other.getSegmentLengthControl() == null ^ this.getSegmentLengthControl() == null)
            return false;
        if (other.getSegmentLengthControl() != null && other.getSegmentLengthControl().equals(this.getSegmentLengthControl()) == false)
            return false;
        if (other.getStreamInfResolution() == null ^ this.getStreamInfResolution() == null)
            return false;
        if (other.getStreamInfResolution() != null && other.getStreamInfResolution().equals(this.getStreamInfResolution()) == false)
            return false;
        if (other.getTargetDurationCompatibilityMode() == null ^ this.getTargetDurationCompatibilityMode() == null)
            return false;
        if (other.getTargetDurationCompatibilityMode() != null
                && other.getTargetDurationCompatibilityMode().equals(this.getTargetDurationCompatibilityMode()) == false)
            return false;
        if (other.getVideoCompositionOffsets() == null ^ this.getVideoCompositionOffsets() == null)
            return false;
        if (other.getVideoCompositionOffsets() != null && other.getVideoCompositionOffsets().equals(this.getVideoCompositionOffsets()) == false)
            return false;
        if (other.getWriteDashManifest() == null ^ this.getWriteDashManifest() == null)
            return false;
        if (other.getWriteDashManifest() != null && other.getWriteDashManifest().equals(this.getWriteDashManifest()) == false)
            return false;
        if (other.getWriteHlsManifest() == null ^ this.getWriteHlsManifest() == null)
            return false;
        if (other.getWriteHlsManifest() != null && other.getWriteHlsManifest().equals(this.getWriteHlsManifest()) == false)
            return false;
        if (other.getWriteSegmentTimelineInRepresentation() == null ^ this.getWriteSegmentTimelineInRepresentation() == null)
            return false;
        if (other.getWriteSegmentTimelineInRepresentation() != null
                && other.getWriteSegmentTimelineInRepresentation().equals(this.getWriteSegmentTimelineInRepresentation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAdditionalManifests() == null) ? 0 : getAdditionalManifests().hashCode());
        hashCode = prime * hashCode + ((getBaseUrl() == null) ? 0 : getBaseUrl().hashCode());
        hashCode = prime * hashCode + ((getClientCache() == null) ? 0 : getClientCache().hashCode());
        hashCode = prime * hashCode + ((getCodecSpecification() == null) ? 0 : getCodecSpecification().hashCode());
        hashCode = prime * hashCode + ((getDashIFrameTrickPlayNameModifier() == null) ? 0 : getDashIFrameTrickPlayNameModifier().hashCode());
        hashCode = prime * hashCode + ((getDashManifestStyle() == null) ? 0 : getDashManifestStyle().hashCode());
        hashCode = prime * hashCode + ((getDestination() == null) ? 0 : getDestination().hashCode());
        hashCode = prime * hashCode + ((getDestinationSettings() == null) ? 0 : getDestinationSettings().hashCode());
        hashCode = prime * hashCode + ((getEncryption() == null) ? 0 : getEncryption().hashCode());
        hashCode = prime * hashCode + ((getFragmentLength() == null) ? 0 : getFragmentLength().hashCode());
        hashCode = prime * hashCode + ((getImageBasedTrickPlay() == null) ? 0 : getImageBasedTrickPlay().hashCode());
        hashCode = prime * hashCode + ((getImageBasedTrickPlaySettings() == null) ? 0 : getImageBasedTrickPlaySettings().hashCode());
        hashCode = prime * hashCode + ((getManifestCompression() == null) ? 0 : getManifestCompression().hashCode());
        hashCode = prime * hashCode + ((getManifestDurationFormat() == null) ? 0 : getManifestDurationFormat().hashCode());
        hashCode = prime * hashCode + ((getMinBufferTime() == null) ? 0 : getMinBufferTime().hashCode());
        hashCode = prime * hashCode + ((getMinFinalSegmentLength() == null) ? 0 : getMinFinalSegmentLength().hashCode());
        hashCode = prime * hashCode + ((getMpdManifestBandwidthType() == null) ? 0 : getMpdManifestBandwidthType().hashCode());
        hashCode = prime * hashCode + ((getMpdProfile() == null) ? 0 : getMpdProfile().hashCode());
        hashCode = prime * hashCode + ((getPtsOffsetHandlingForBFrames() == null) ? 0 : getPtsOffsetHandlingForBFrames().hashCode());
        hashCode = prime * hashCode + ((getSegmentControl() == null) ? 0 : getSegmentControl().hashCode());
        hashCode = prime * hashCode + ((getSegmentLength() == null) ? 0 : getSegmentLength().hashCode());
        hashCode = prime * hashCode + ((getSegmentLengthControl() == null) ? 0 : getSegmentLengthControl().hashCode());
        hashCode = prime * hashCode + ((getStreamInfResolution() == null) ? 0 : getStreamInfResolution().hashCode());
        hashCode = prime * hashCode + ((getTargetDurationCompatibilityMode() == null) ? 0 : getTargetDurationCompatibilityMode().hashCode());
        hashCode = prime * hashCode + ((getVideoCompositionOffsets() == null) ? 0 : getVideoCompositionOffsets().hashCode());
        hashCode = prime * hashCode + ((getWriteDashManifest() == null) ? 0 : getWriteDashManifest().hashCode());
        hashCode = prime * hashCode + ((getWriteHlsManifest() == null) ? 0 : getWriteHlsManifest().hashCode());
        hashCode = prime * hashCode + ((getWriteSegmentTimelineInRepresentation() == null) ? 0 : getWriteSegmentTimelineInRepresentation().hashCode());
        return hashCode;
    }

    @Override
    public CmafGroupSettings clone() {
        try {
            return (CmafGroupSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mediaconvert.model.transform.CmafGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
