/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * Settings related to IMSC captions. IMSC is a sidecar format that holds captions in a file that is separate from the
 * video container. Set up sidecar captions in the same output group, but different output from your video. For more
 * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html.
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ImscDestinationSettings"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ImscDestinationSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of hearing: Set
     * Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes to your output HLS or
     * DASH manifest. For HLS manifests, MediaConvert adds the following accessibility attributes under EXT-X-MEDIA for
     * this track:
     * CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     * AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this track:
     * <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is not intended to
     * provide such accessibility: Keep the default value, Disabled. When you do, for DASH manifests, MediaConvert
     * instead adds the following in the adaptation set for this track: <Role schemeIDUri="urn:mpeg:dash:role:2011"
     * value="subtitle"/>.
     */
    private String accessibility;
    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions
     * source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable
     * this setting for simplified output captions.
     */
    private String stylePassthrough;

    /**
     * If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of hearing: Set
     * Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes to your output HLS or
     * DASH manifest. For HLS manifests, MediaConvert adds the following accessibility attributes under EXT-X-MEDIA for
     * this track:
     * CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     * AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this track:
     * <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is not intended to
     * provide such accessibility: Keep the default value, Disabled. When you do, for DASH manifests, MediaConvert
     * instead adds the following in the adaptation set for this track: <Role schemeIDUri="urn:mpeg:dash:role:2011"
     * value="subtitle"/>.
     * 
     * @param accessibility
     *        If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of
     *        hearing: Set Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes
     *        to your output HLS or DASH manifest. For HLS manifests, MediaConvert adds the following accessibility
     *        attributes under EXT-X-MEDIA for this track: CHARACTERISTICS=
     *        "public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     *        AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this
     *        track: <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is
     *        not intended to provide such accessibility: Keep the default value, Disabled. When you do, for DASH
     *        manifests, MediaConvert instead adds the following in the adaptation set for this track: <Role
     *        schemeIDUri="urn:mpeg:dash:role:2011" value="subtitle"/>.
     * @see ImscAccessibilitySubs
     */

    public void setAccessibility(String accessibility) {
        this.accessibility = accessibility;
    }

    /**
     * If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of hearing: Set
     * Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes to your output HLS or
     * DASH manifest. For HLS manifests, MediaConvert adds the following accessibility attributes under EXT-X-MEDIA for
     * this track:
     * CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     * AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this track:
     * <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is not intended to
     * provide such accessibility: Keep the default value, Disabled. When you do, for DASH manifests, MediaConvert
     * instead adds the following in the adaptation set for this track: <Role schemeIDUri="urn:mpeg:dash:role:2011"
     * value="subtitle"/>.
     * 
     * @return If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of
     *         hearing: Set Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes
     *         to your output HLS or DASH manifest. For HLS manifests, MediaConvert adds the following accessibility
     *         attributes under EXT-X-MEDIA for this track: CHARACTERISTICS=
     *         "public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     *         AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this
     *         track: <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is
     *         not intended to provide such accessibility: Keep the default value, Disabled. When you do, for DASH
     *         manifests, MediaConvert instead adds the following in the adaptation set for this track: <Role
     *         schemeIDUri="urn:mpeg:dash:role:2011" value="subtitle"/>.
     * @see ImscAccessibilitySubs
     */

    public String getAccessibility() {
        return this.accessibility;
    }

    /**
     * If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of hearing: Set
     * Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes to your output HLS or
     * DASH manifest. For HLS manifests, MediaConvert adds the following accessibility attributes under EXT-X-MEDIA for
     * this track:
     * CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     * AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this track:
     * <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is not intended to
     * provide such accessibility: Keep the default value, Disabled. When you do, for DASH manifests, MediaConvert
     * instead adds the following in the adaptation set for this track: <Role schemeIDUri="urn:mpeg:dash:role:2011"
     * value="subtitle"/>.
     * 
     * @param accessibility
     *        If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of
     *        hearing: Set Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes
     *        to your output HLS or DASH manifest. For HLS manifests, MediaConvert adds the following accessibility
     *        attributes under EXT-X-MEDIA for this track: CHARACTERISTICS=
     *        "public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     *        AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this
     *        track: <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is
     *        not intended to provide such accessibility: Keep the default value, Disabled. When you do, for DASH
     *        manifests, MediaConvert instead adds the following in the adaptation set for this track: <Role
     *        schemeIDUri="urn:mpeg:dash:role:2011" value="subtitle"/>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ImscAccessibilitySubs
     */

    public ImscDestinationSettings withAccessibility(String accessibility) {
        setAccessibility(accessibility);
        return this;
    }

    /**
     * If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of hearing: Set
     * Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes to your output HLS or
     * DASH manifest. For HLS manifests, MediaConvert adds the following accessibility attributes under EXT-X-MEDIA for
     * this track:
     * CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     * AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this track:
     * <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is not intended to
     * provide such accessibility: Keep the default value, Disabled. When you do, for DASH manifests, MediaConvert
     * instead adds the following in the adaptation set for this track: <Role schemeIDUri="urn:mpeg:dash:role:2011"
     * value="subtitle"/>.
     * 
     * @param accessibility
     *        If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of
     *        hearing: Set Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes
     *        to your output HLS or DASH manifest. For HLS manifests, MediaConvert adds the following accessibility
     *        attributes under EXT-X-MEDIA for this track: CHARACTERISTICS=
     *        "public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound" and
     *        AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this
     *        track: <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is
     *        not intended to provide such accessibility: Keep the default value, Disabled. When you do, for DASH
     *        manifests, MediaConvert instead adds the following in the adaptation set for this track: <Role
     *        schemeIDUri="urn:mpeg:dash:role:2011" value="subtitle"/>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ImscAccessibilitySubs
     */

    public ImscDestinationSettings withAccessibility(ImscAccessibilitySubs accessibility) {
        this.accessibility = accessibility.toString();
        return this;
    }

    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions
     * source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable
     * this setting for simplified output captions.
     * 
     * @param stylePassthrough
     *        Keep this setting enabled to have MediaConvert use the font style and position information from the
     *        captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT,
     *        or TTML. Disable this setting for simplified output captions.
     * @see ImscStylePassthrough
     */

    public void setStylePassthrough(String stylePassthrough) {
        this.stylePassthrough = stylePassthrough;
    }

    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions
     * source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable
     * this setting for simplified output captions.
     * 
     * @return Keep this setting enabled to have MediaConvert use the font style and position information from the
     *         captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT,
     *         or TTML. Disable this setting for simplified output captions.
     * @see ImscStylePassthrough
     */

    public String getStylePassthrough() {
        return this.stylePassthrough;
    }

    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions
     * source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable
     * this setting for simplified output captions.
     * 
     * @param stylePassthrough
     *        Keep this setting enabled to have MediaConvert use the font style and position information from the
     *        captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT,
     *        or TTML. Disable this setting for simplified output captions.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ImscStylePassthrough
     */

    public ImscDestinationSettings withStylePassthrough(String stylePassthrough) {
        setStylePassthrough(stylePassthrough);
        return this;
    }

    /**
     * Keep this setting enabled to have MediaConvert use the font style and position information from the captions
     * source in the output. This option is available only when your input captions are IMSC, SMPTE-TT, or TTML. Disable
     * this setting for simplified output captions.
     * 
     * @param stylePassthrough
     *        Keep this setting enabled to have MediaConvert use the font style and position information from the
     *        captions source in the output. This option is available only when your input captions are IMSC, SMPTE-TT,
     *        or TTML. Disable this setting for simplified output captions.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ImscStylePassthrough
     */

    public ImscDestinationSettings withStylePassthrough(ImscStylePassthrough stylePassthrough) {
        this.stylePassthrough = stylePassthrough.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccessibility() != null)
            sb.append("Accessibility: ").append(getAccessibility()).append(",");
        if (getStylePassthrough() != null)
            sb.append("StylePassthrough: ").append(getStylePassthrough());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ImscDestinationSettings == false)
            return false;
        ImscDestinationSettings other = (ImscDestinationSettings) obj;
        if (other.getAccessibility() == null ^ this.getAccessibility() == null)
            return false;
        if (other.getAccessibility() != null && other.getAccessibility().equals(this.getAccessibility()) == false)
            return false;
        if (other.getStylePassthrough() == null ^ this.getStylePassthrough() == null)
            return false;
        if (other.getStylePassthrough() != null && other.getStylePassthrough().equals(this.getStylePassthrough()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccessibility() == null) ? 0 : getAccessibility().hashCode());
        hashCode = prime * hashCode + ((getStylePassthrough() == null) ? 0 : getStylePassthrough().hashCode());
        return hashCode;
    }

    @Override
    public ImscDestinationSettings clone() {
        try {
            return (ImscDestinationSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mediaconvert.model.transform.ImscDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
