/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * Settings related to your Microsoft Smooth Streaming output package. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html.
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/MsSmoothGroupSettings" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MsSmoothGroupSettings implements Serializable, Cloneable, StructuredPojo {

    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming
     * output group in your job. This default manifest references every output in the output group. To create additional
     * manifests that reference a subset of the outputs in the output group, specify a list of them here.
     */
    private java.util.List<MsSmoothAdditionalManifest> additionalManifests;
    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     */
    private String audioDeduplication;
    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     */
    private String destination;
    /** Settings associated with the destination. Will vary based on the type of destination */
    private DestinationSettings destinationSettings;
    /** If you are using DRM, set DRM System to specify the value SpekeKeyProvider. */
    private MsSmoothEncryptionSettings encryption;
    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    private Integer fragmentLength;
    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     */
    private String fragmentLengthControl;
    /**
     * Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are utf8
     * and utf16.
     */
    private String manifestEncoding;

    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming
     * output group in your job. This default manifest references every output in the output group. To create additional
     * manifests that reference a subset of the outputs in the output group, specify a list of them here.
     * 
     * @return By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
     *         Streaming output group in your job. This default manifest references every output in the output group. To
     *         create additional manifests that reference a subset of the outputs in the output group, specify a list of
     *         them here.
     */

    public java.util.List<MsSmoothAdditionalManifest> getAdditionalManifests() {
        return additionalManifests;
    }

    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming
     * output group in your job. This default manifest references every output in the output group. To create additional
     * manifests that reference a subset of the outputs in the output group, specify a list of them here.
     * 
     * @param additionalManifests
     *        By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
     *        Streaming output group in your job. This default manifest references every output in the output group. To
     *        create additional manifests that reference a subset of the outputs in the output group, specify a list of
     *        them here.
     */

    public void setAdditionalManifests(java.util.Collection<MsSmoothAdditionalManifest> additionalManifests) {
        if (additionalManifests == null) {
            this.additionalManifests = null;
            return;
        }

        this.additionalManifests = new java.util.ArrayList<MsSmoothAdditionalManifest>(additionalManifests);
    }

    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming
     * output group in your job. This default manifest references every output in the output group. To create additional
     * manifests that reference a subset of the outputs in the output group, specify a list of them here.
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAdditionalManifests(java.util.Collection)} or {@link #withAdditionalManifests(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param additionalManifests
     *        By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
     *        Streaming output group in your job. This default manifest references every output in the output group. To
     *        create additional manifests that reference a subset of the outputs in the output group, specify a list of
     *        them here.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MsSmoothGroupSettings withAdditionalManifests(MsSmoothAdditionalManifest... additionalManifests) {
        if (this.additionalManifests == null) {
            setAdditionalManifests(new java.util.ArrayList<MsSmoothAdditionalManifest>(additionalManifests.length));
        }
        for (MsSmoothAdditionalManifest ele : additionalManifests) {
            this.additionalManifests.add(ele);
        }
        return this;
    }

    /**
     * By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth Streaming
     * output group in your job. This default manifest references every output in the output group. To create additional
     * manifests that reference a subset of the outputs in the output group, specify a list of them here.
     * 
     * @param additionalManifests
     *        By default, the service creates one .ism Microsoft Smooth Streaming manifest for each Microsoft Smooth
     *        Streaming output group in your job. This default manifest references every output in the output group. To
     *        create additional manifests that reference a subset of the outputs in the output group, specify a list of
     *        them here.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MsSmoothGroupSettings withAdditionalManifests(java.util.Collection<MsSmoothAdditionalManifest> additionalManifests) {
        setAdditionalManifests(additionalManifests);
        return this;
    }

    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     * 
     * @param audioDeduplication
     *        COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
     *        group into a single audio stream.
     * @see MsSmoothAudioDeduplication
     */

    public void setAudioDeduplication(String audioDeduplication) {
        this.audioDeduplication = audioDeduplication;
    }

    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     * 
     * @return COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
     *         group into a single audio stream.
     * @see MsSmoothAudioDeduplication
     */

    public String getAudioDeduplication() {
        return this.audioDeduplication;
    }

    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     * 
     * @param audioDeduplication
     *        COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
     *        group into a single audio stream.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MsSmoothAudioDeduplication
     */

    public MsSmoothGroupSettings withAudioDeduplication(String audioDeduplication) {
        setAudioDeduplication(audioDeduplication);
        return this;
    }

    /**
     * COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output group into
     * a single audio stream.
     * 
     * @param audioDeduplication
     *        COMBINE_DUPLICATE_STREAMS combines identical audio encoding settings across a Microsoft Smooth output
     *        group into a single audio stream.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MsSmoothAudioDeduplication
     */

    public MsSmoothGroupSettings withAudioDeduplication(MsSmoothAudioDeduplication audioDeduplication) {
        this.audioDeduplication = audioDeduplication.toString();
        return this;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @param destination
     *        Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     *        identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     *        input file. If your job has multiple inputs, the service uses the filename of the first input file.
     */

    public void setDestination(String destination) {
        this.destination = destination;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination to specify the S3 output location and the output filename base. Destination accepts
     *         format identifiers. If you do not specify the base filename in the URI, the service will use the filename
     *         of the input file. If your job has multiple inputs, the service uses the filename of the first input
     *         file.
     */

    public String getDestination() {
        return this.destination;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @param destination
     *        Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     *        identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     *        input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MsSmoothGroupSettings withDestination(String destination) {
        setDestination(destination);
        return this;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @param destinationSettings
     *        Settings associated with the destination. Will vary based on the type of destination
     */

    public void setDestinationSettings(DestinationSettings destinationSettings) {
        this.destinationSettings = destinationSettings;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */

    public DestinationSettings getDestinationSettings() {
        return this.destinationSettings;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @param destinationSettings
     *        Settings associated with the destination. Will vary based on the type of destination
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MsSmoothGroupSettings withDestinationSettings(DestinationSettings destinationSettings) {
        setDestinationSettings(destinationSettings);
        return this;
    }

    /**
     * If you are using DRM, set DRM System to specify the value SpekeKeyProvider.
     * 
     * @param encryption
     *        If you are using DRM, set DRM System to specify the value SpekeKeyProvider.
     */

    public void setEncryption(MsSmoothEncryptionSettings encryption) {
        this.encryption = encryption;
    }

    /**
     * If you are using DRM, set DRM System to specify the value SpekeKeyProvider.
     * 
     * @return If you are using DRM, set DRM System to specify the value SpekeKeyProvider.
     */

    public MsSmoothEncryptionSettings getEncryption() {
        return this.encryption;
    }

    /**
     * If you are using DRM, set DRM System to specify the value SpekeKeyProvider.
     * 
     * @param encryption
     *        If you are using DRM, set DRM System to specify the value SpekeKeyProvider.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MsSmoothGroupSettings withEncryption(MsSmoothEncryptionSettings encryption) {
        setEncryption(encryption);
        return this;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param fragmentLength
     *        Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     */

    public void setFragmentLength(Integer fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @return Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     */

    public Integer getFragmentLength() {
        return this.fragmentLength;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param fragmentLength
     *        Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MsSmoothGroupSettings withFragmentLength(Integer fragmentLength) {
        setFragmentLength(fragmentLength);
        return this;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param fragmentLengthControl
     *        Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see MsSmoothFragmentLengthControl
     */

    public void setFragmentLengthControl(String fragmentLengthControl) {
        this.fragmentLengthControl = fragmentLengthControl;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @return Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see MsSmoothFragmentLengthControl
     */

    public String getFragmentLengthControl() {
        return this.fragmentLengthControl;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param fragmentLengthControl
     *        Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MsSmoothFragmentLengthControl
     */

    public MsSmoothGroupSettings withFragmentLengthControl(String fragmentLengthControl) {
        setFragmentLengthControl(fragmentLengthControl);
        return this;
    }

    /**
     * Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use the
     * exact length that you specify with the setting Fragment length. This might result in extra I-frames. Choose
     * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * 
     * @param fragmentLengthControl
     *        Specify how you want MediaConvert to determine the fragment length. Choose Exact to have the encoder use
     *        the exact length that you specify with the setting Fragment length. This might result in extra I-frames.
     *        Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MsSmoothFragmentLengthControl
     */

    public MsSmoothGroupSettings withFragmentLengthControl(MsSmoothFragmentLengthControl fragmentLengthControl) {
        this.fragmentLengthControl = fragmentLengthControl.toString();
        return this;
    }

    /**
     * Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are utf8
     * and utf16.
     * 
     * @param manifestEncoding
     *        Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are
     *        utf8 and utf16.
     * @see MsSmoothManifestEncoding
     */

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    /**
     * Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are utf8
     * and utf16.
     * 
     * @return Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options
     *         are utf8 and utf16.
     * @see MsSmoothManifestEncoding
     */

    public String getManifestEncoding() {
        return this.manifestEncoding;
    }

    /**
     * Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are utf8
     * and utf16.
     * 
     * @param manifestEncoding
     *        Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are
     *        utf8 and utf16.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MsSmoothManifestEncoding
     */

    public MsSmoothGroupSettings withManifestEncoding(String manifestEncoding) {
        setManifestEncoding(manifestEncoding);
        return this;
    }

    /**
     * Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are utf8
     * and utf16.
     * 
     * @param manifestEncoding
     *        Use Manifest encoding to specify the encoding format for the server and client manifest. Valid options are
     *        utf8 and utf16.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MsSmoothManifestEncoding
     */

    public MsSmoothGroupSettings withManifestEncoding(MsSmoothManifestEncoding manifestEncoding) {
        this.manifestEncoding = manifestEncoding.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAdditionalManifests() != null)
            sb.append("AdditionalManifests: ").append(getAdditionalManifests()).append(",");
        if (getAudioDeduplication() != null)
            sb.append("AudioDeduplication: ").append(getAudioDeduplication()).append(",");
        if (getDestination() != null)
            sb.append("Destination: ").append(getDestination()).append(",");
        if (getDestinationSettings() != null)
            sb.append("DestinationSettings: ").append(getDestinationSettings()).append(",");
        if (getEncryption() != null)
            sb.append("Encryption: ").append(getEncryption()).append(",");
        if (getFragmentLength() != null)
            sb.append("FragmentLength: ").append(getFragmentLength()).append(",");
        if (getFragmentLengthControl() != null)
            sb.append("FragmentLengthControl: ").append(getFragmentLengthControl()).append(",");
        if (getManifestEncoding() != null)
            sb.append("ManifestEncoding: ").append(getManifestEncoding());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MsSmoothGroupSettings == false)
            return false;
        MsSmoothGroupSettings other = (MsSmoothGroupSettings) obj;
        if (other.getAdditionalManifests() == null ^ this.getAdditionalManifests() == null)
            return false;
        if (other.getAdditionalManifests() != null && other.getAdditionalManifests().equals(this.getAdditionalManifests()) == false)
            return false;
        if (other.getAudioDeduplication() == null ^ this.getAudioDeduplication() == null)
            return false;
        if (other.getAudioDeduplication() != null && other.getAudioDeduplication().equals(this.getAudioDeduplication()) == false)
            return false;
        if (other.getDestination() == null ^ this.getDestination() == null)
            return false;
        if (other.getDestination() != null && other.getDestination().equals(this.getDestination()) == false)
            return false;
        if (other.getDestinationSettings() == null ^ this.getDestinationSettings() == null)
            return false;
        if (other.getDestinationSettings() != null && other.getDestinationSettings().equals(this.getDestinationSettings()) == false)
            return false;
        if (other.getEncryption() == null ^ this.getEncryption() == null)
            return false;
        if (other.getEncryption() != null && other.getEncryption().equals(this.getEncryption()) == false)
            return false;
        if (other.getFragmentLength() == null ^ this.getFragmentLength() == null)
            return false;
        if (other.getFragmentLength() != null && other.getFragmentLength().equals(this.getFragmentLength()) == false)
            return false;
        if (other.getFragmentLengthControl() == null ^ this.getFragmentLengthControl() == null)
            return false;
        if (other.getFragmentLengthControl() != null && other.getFragmentLengthControl().equals(this.getFragmentLengthControl()) == false)
            return false;
        if (other.getManifestEncoding() == null ^ this.getManifestEncoding() == null)
            return false;
        if (other.getManifestEncoding() != null && other.getManifestEncoding().equals(this.getManifestEncoding()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAdditionalManifests() == null) ? 0 : getAdditionalManifests().hashCode());
        hashCode = prime * hashCode + ((getAudioDeduplication() == null) ? 0 : getAudioDeduplication().hashCode());
        hashCode = prime * hashCode + ((getDestination() == null) ? 0 : getDestination().hashCode());
        hashCode = prime * hashCode + ((getDestinationSettings() == null) ? 0 : getDestinationSettings().hashCode());
        hashCode = prime * hashCode + ((getEncryption() == null) ? 0 : getEncryption().hashCode());
        hashCode = prime * hashCode + ((getFragmentLength() == null) ? 0 : getFragmentLength().hashCode());
        hashCode = prime * hashCode + ((getFragmentLengthControl() == null) ? 0 : getFragmentLengthControl().hashCode());
        hashCode = prime * hashCode + ((getManifestEncoding() == null) ? 0 : getManifestEncoding().hashCode());
        return hashCode;
    }

    @Override
    public MsSmoothGroupSettings clone() {
        try {
            return (MsSmoothGroupSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mediaconvert.model.transform.MsSmoothGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
