/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model;

import javax.annotation.Generated;

/**
 * If the IMSC captions track is intended to provide accessibility for people who are deaf or hard of hearing: Set
 * Accessibility subtitles to Enabled. When you do, MediaConvert adds accessibility attributes to your output HLS or
 * DASH manifest. For HLS manifests, MediaConvert adds the following accessibility attributes under EXT-X-MEDIA for this
 * track: CHARACTERISTICS="public.accessibility.describes-spoken-dialog,public.accessibility.describes-music-and-sound"
 * and AUTOSELECT="YES". For DASH manifests, MediaConvert adds the following in the adaptation set for this track:
 * <Accessibility schemeIdUri="urn:mpeg:dash:role:2011" value="caption"/>. If the captions track is not intended to
 * provide such accessibility: Keep the default value, Disabled. When you do, for DASH manifests, MediaConvert instead
 * adds the following in the adaptation set for this track: <Role schemeIDUri="urn:mpeg:dash:role:2011"
 * value="subtitle"/>.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum ImscAccessibilitySubs {

    DISABLED("DISABLED"),
    ENABLED("ENABLED");

    private String value;

    private ImscAccessibilitySubs(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return ImscAccessibilitySubs corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static ImscAccessibilitySubs fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (ImscAccessibilitySubs enumEntry : ImscAccessibilitySubs.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
