/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.mediaconvert.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CmfcSettings JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CmfcSettingsJsonUnmarshaller implements Unmarshaller<CmfcSettings, JsonUnmarshallerContext> {

    public CmfcSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        CmfcSettings cmfcSettings = new CmfcSettings();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("audioDuration", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setAudioDuration(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("audioGroupId", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setAudioGroupId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("audioRenditionSets", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setAudioRenditionSets(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("audioTrackType", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setAudioTrackType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("descriptiveVideoServiceFlag", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setDescriptiveVideoServiceFlag(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("iFrameOnlyManifest", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setIFrameOnlyManifest(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("klvMetadata", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setKlvMetadata(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("manifestMetadataSignaling", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setManifestMetadataSignaling(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("scte35Esam", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setScte35Esam(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("scte35Source", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setScte35Source(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("timedMetadata", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setTimedMetadata(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("timedMetadataBoxVersion", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setTimedMetadataBoxVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("timedMetadataSchemeIdUri", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setTimedMetadataSchemeIdUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("timedMetadataValue", targetDepth)) {
                    context.nextToken();
                    cmfcSettings.setTimedMetadataValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return cmfcSettings;
    }

    private static CmfcSettingsJsonUnmarshaller instance;

    public static CmfcSettingsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new CmfcSettingsJsonUnmarshaller();
        return instance;
    }
}
