/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconvert;

import javax.annotation.Generated;

import com.amazonaws.services.mediaconvert.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMediaConvert}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMediaConvert implements AWSMediaConvert {

    protected AbstractAWSMediaConvert() {
    }

    @Override
    public AssociateCertificateResult associateCertificate(AssociateCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateJobTemplateResult createJobTemplate(CreateJobTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePresetResult createPreset(CreatePresetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteJobTemplateResult deleteJobTemplate(DeleteJobTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyResult deletePolicy(DeletePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePresetResult deletePreset(DeletePresetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointsResult describeEndpoints(DescribeEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateCertificateResult disassociateCertificate(DisassociateCertificateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetJobTemplateResult getJobTemplate(GetJobTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPresetResult getPreset(GetPresetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQueueResult getQueue(GetQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobTemplatesResult listJobTemplates(ListJobTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPresetsResult listPresets(ListPresetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPolicyResult putPolicy(PutPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateJobTemplateResult updateJobTemplate(UpdateJobTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePresetResult updatePreset(UpdatePresetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQueueResult updateQueue(UpdateQueueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
