/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.Thumbnail;
import com.amazonaws.services.medialive.model.transform.ThumbnailDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThumbnailDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String pipelineId;
    private List<Thumbnail> thumbnails;

    public void setPipelineId(String pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public ThumbnailDetail withPipelineId(String pipelineId) {
        this.setPipelineId(pipelineId);
        return this;
    }

    public List<Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public void setThumbnails(Collection<Thumbnail> thumbnails) {
        if (thumbnails == null) {
            this.thumbnails = null;
            return;
        }
        this.thumbnails = new ArrayList<Thumbnail>(thumbnails);
    }

    public ThumbnailDetail withThumbnails(Thumbnail ... thumbnails) {
        if (this.thumbnails == null) {
            this.setThumbnails(new ArrayList<Thumbnail>(thumbnails.length));
        }
        for (Thumbnail ele : thumbnails) {
            this.thumbnails.add(ele);
        }
        return this;
    }

    public ThumbnailDetail withThumbnails(Collection<Thumbnail> thumbnails) {
        this.setThumbnails(thumbnails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineId() != null) {
            sb.append("PipelineId: ").append(this.getPipelineId()).append(",");
        }
        if (this.getThumbnails() != null) {
            sb.append("Thumbnails: ").append(this.getThumbnails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailDetail)) {
            return false;
        }
        ThumbnailDetail other = (ThumbnailDetail)obj;
        if (other.getPipelineId() == null ^ this.getPipelineId() == null) {
            return false;
        }
        if (other.getPipelineId() != null && !other.getPipelineId().equals(this.getPipelineId())) {
            return false;
        }
        if (other.getThumbnails() == null ^ this.getThumbnails() == null) {
            return false;
        }
        return other.getThumbnails() == null || other.getThumbnails().equals(this.getThumbnails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineId() == null ? 0 : this.getPipelineId().hashCode());
        hashCode = 31 * hashCode + (this.getThumbnails() == null ? 0 : this.getThumbnails().hashCode());
        return hashCode;
    }

    public ThumbnailDetail clone() {
        try {
            return (ThumbnailDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThumbnailDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

