/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.medialive.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.medialive.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * InputDeviceConfigurableSettingsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class InputDeviceConfigurableSettingsMarshaller {

    private static final MarshallingInfo<String> CONFIGUREDINPUT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configuredInput").build();
    private static final MarshallingInfo<Integer> MAXBITRATE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxBitrate").build();
    private static final MarshallingInfo<Integer> LATENCYMS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latencyMs").build();
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("codec").build();
    private static final MarshallingInfo<StructuredPojo> MEDIACONNECTSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaconnectSettings").build();
    private static final MarshallingInfo<List> AUDIOCHANNELPAIRS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioChannelPairs").build();

    private static final InputDeviceConfigurableSettingsMarshaller instance = new InputDeviceConfigurableSettingsMarshaller();

    public static InputDeviceConfigurableSettingsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(InputDeviceConfigurableSettings inputDeviceConfigurableSettings, ProtocolMarshaller protocolMarshaller) {

        if (inputDeviceConfigurableSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(inputDeviceConfigurableSettings.getConfiguredInput(), CONFIGUREDINPUT_BINDING);
            protocolMarshaller.marshall(inputDeviceConfigurableSettings.getMaxBitrate(), MAXBITRATE_BINDING);
            protocolMarshaller.marshall(inputDeviceConfigurableSettings.getLatencyMs(), LATENCYMS_BINDING);
            protocolMarshaller.marshall(inputDeviceConfigurableSettings.getCodec(), CODEC_BINDING);
            protocolMarshaller.marshall(inputDeviceConfigurableSettings.getMediaconnectSettings(), MEDIACONNECTSETTINGS_BINDING);
            protocolMarshaller.marshall(inputDeviceConfigurableSettings.getAudioChannelPairs(), AUDIOCHANNELPAIRS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
