/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.Algorithm;
import com.amazonaws.services.medialive.model.transform.SrtCallerDecryptionRequestMarshaller;
import java.io.Serializable;

public class SrtCallerDecryptionRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithm;
    private String passphraseSecretArn;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public SrtCallerDecryptionRequest withAlgorithm(String algorithm) {
        this.setAlgorithm(algorithm);
        return this;
    }

    public SrtCallerDecryptionRequest withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm.toString();
        return this;
    }

    public void setPassphraseSecretArn(String passphraseSecretArn) {
        this.passphraseSecretArn = passphraseSecretArn;
    }

    public String getPassphraseSecretArn() {
        return this.passphraseSecretArn;
    }

    public SrtCallerDecryptionRequest withPassphraseSecretArn(String passphraseSecretArn) {
        this.setPassphraseSecretArn(passphraseSecretArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithm() != null) {
            sb.append("Algorithm: ").append(this.getAlgorithm()).append(",");
        }
        if (this.getPassphraseSecretArn() != null) {
            sb.append("PassphraseSecretArn: ").append(this.getPassphraseSecretArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerDecryptionRequest)) {
            return false;
        }
        SrtCallerDecryptionRequest other = (SrtCallerDecryptionRequest)obj;
        if (other.getAlgorithm() == null ^ this.getAlgorithm() == null) {
            return false;
        }
        if (other.getAlgorithm() != null && !other.getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (other.getPassphraseSecretArn() == null ^ this.getPassphraseSecretArn() == null) {
            return false;
        }
        return other.getPassphraseSecretArn() == null || other.getPassphraseSecretArn().equals(this.getPassphraseSecretArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithm() == null ? 0 : this.getAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getPassphraseSecretArn() == null ? 0 : this.getPassphraseSecretArn().hashCode());
        return hashCode;
    }

    public SrtCallerDecryptionRequest clone() {
        try {
            return (SrtCallerDecryptionRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SrtCallerDecryptionRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

