/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagev2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagev2.model.DrmSystem;
import com.amazonaws.services.mediapackagev2.model.EncryptionContractConfiguration;
import com.amazonaws.services.mediapackagev2.model.transform.SpekeKeyProviderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpekeKeyProvider
implements Serializable,
Cloneable,
StructuredPojo {
    private EncryptionContractConfiguration encryptionContractConfiguration;
    private String resourceId;
    private List<String> drmSystems;
    private String roleArn;
    private String url;

    public void setEncryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
        this.encryptionContractConfiguration = encryptionContractConfiguration;
    }

    public EncryptionContractConfiguration getEncryptionContractConfiguration() {
        return this.encryptionContractConfiguration;
    }

    public SpekeKeyProvider withEncryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
        this.setEncryptionContractConfiguration(encryptionContractConfiguration);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public SpekeKeyProvider withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public List<String> getDrmSystems() {
        return this.drmSystems;
    }

    public void setDrmSystems(Collection<String> drmSystems) {
        if (drmSystems == null) {
            this.drmSystems = null;
            return;
        }
        this.drmSystems = new ArrayList<String>(drmSystems);
    }

    public SpekeKeyProvider withDrmSystems(String ... drmSystems) {
        if (this.drmSystems == null) {
            this.setDrmSystems(new ArrayList<String>(drmSystems.length));
        }
        for (String ele : drmSystems) {
            this.drmSystems.add(ele);
        }
        return this;
    }

    public SpekeKeyProvider withDrmSystems(Collection<String> drmSystems) {
        this.setDrmSystems(drmSystems);
        return this;
    }

    public SpekeKeyProvider withDrmSystems(DrmSystem ... drmSystems) {
        ArrayList<String> drmSystemsCopy = new ArrayList<String>(drmSystems.length);
        for (DrmSystem value : drmSystems) {
            drmSystemsCopy.add(value.toString());
        }
        if (this.getDrmSystems() == null) {
            this.setDrmSystems(drmSystemsCopy);
        } else {
            this.getDrmSystems().addAll(drmSystemsCopy);
        }
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public SpekeKeyProvider withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public SpekeKeyProvider withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionContractConfiguration() != null) {
            sb.append("EncryptionContractConfiguration: ").append(this.getEncryptionContractConfiguration()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getDrmSystems() != null) {
            sb.append("DrmSystems: ").append(this.getDrmSystems()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider)obj;
        if (other.getEncryptionContractConfiguration() == null ^ this.getEncryptionContractConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionContractConfiguration() != null && !other.getEncryptionContractConfiguration().equals(this.getEncryptionContractConfiguration())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getDrmSystems() == null ^ this.getDrmSystems() == null) {
            return false;
        }
        if (other.getDrmSystems() != null && !other.getDrmSystems().equals(this.getDrmSystems())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        return other.getUrl() == null || other.getUrl().equals(this.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionContractConfiguration() == null ? 0 : this.getEncryptionContractConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getDrmSystems() == null ? 0 : this.getDrmSystems().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        return hashCode;
    }

    public SpekeKeyProvider clone() {
        try {
            return (SpekeKeyProvider)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpekeKeyProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

