/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediapackagevod.AWSMediaPackageVod;
import com.amazonaws.services.mediapackagevod.AWSMediaPackageVodClientBuilder;
import com.amazonaws.services.mediapackagevod.model.AWSMediaPackageVodException;
import com.amazonaws.services.mediapackagevod.model.CreateAssetRequest;
import com.amazonaws.services.mediapackagevod.model.CreateAssetResult;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingConfigurationRequest;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingConfigurationResult;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.CreatePackagingGroupResult;
import com.amazonaws.services.mediapackagevod.model.DeleteAssetRequest;
import com.amazonaws.services.mediapackagevod.model.DeleteAssetResult;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingConfigurationRequest;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingConfigurationResult;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.DeletePackagingGroupResult;
import com.amazonaws.services.mediapackagevod.model.DescribeAssetRequest;
import com.amazonaws.services.mediapackagevod.model.DescribeAssetResult;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingConfigurationRequest;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingConfigurationResult;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingGroupRequest;
import com.amazonaws.services.mediapackagevod.model.DescribePackagingGroupResult;
import com.amazonaws.services.mediapackagevod.model.ForbiddenException;
import com.amazonaws.services.mediapackagevod.model.InternalServerErrorException;
import com.amazonaws.services.mediapackagevod.model.ListAssetsRequest;
import com.amazonaws.services.mediapackagevod.model.ListAssetsResult;
import com.amazonaws.services.mediapackagevod.model.ListPackagingConfigurationsRequest;
import com.amazonaws.services.mediapackagevod.model.ListPackagingConfigurationsResult;
import com.amazonaws.services.mediapackagevod.model.ListPackagingGroupsRequest;
import com.amazonaws.services.mediapackagevod.model.ListPackagingGroupsResult;
import com.amazonaws.services.mediapackagevod.model.NotFoundException;
import com.amazonaws.services.mediapackagevod.model.ServiceUnavailableException;
import com.amazonaws.services.mediapackagevod.model.TooManyRequestsException;
import com.amazonaws.services.mediapackagevod.model.UnprocessableEntityException;
import com.amazonaws.services.mediapackagevod.model.transform.CreateAssetRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.CreateAssetResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.CreatePackagingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.CreatePackagingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.CreatePackagingGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.CreatePackagingGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DeleteAssetRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DeleteAssetResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DeletePackagingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DeletePackagingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DeletePackagingGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DeletePackagingGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DescribeAssetRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DescribeAssetResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DescribePackagingConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DescribePackagingConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DescribePackagingGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.DescribePackagingGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.ListAssetsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.ListAssetsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.ListPackagingConfigurationsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.ListPackagingConfigurationsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.ListPackagingGroupsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagevod.model.transform.ListPackagingGroupsResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaPackageVodClient
extends AmazonWebServiceClient
implements AWSMediaPackageVod {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaPackageVod.class);
    private static final String DEFAULT_SIGNING_NAME = "mediapackage-vod";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withModeledClass(UnprocessableEntityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AWSMediaPackageVodException.class));

    public static AWSMediaPackageVodClientBuilder builder() {
        return AWSMediaPackageVodClientBuilder.standard();
    }

    AWSMediaPackageVodClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaPackageVodClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mediapackage-vod.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediapackagevod/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediapackagevod/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateAssetResult createAsset(CreateAssetRequest request) {
        request = (CreateAssetRequest)this.beforeClientExecution(request);
        return this.executeCreateAsset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAssetResult executeCreateAsset(CreateAssetRequest createAssetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAssetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAssetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAssetRequestProtocolMarshaller(protocolFactory).marshall((CreateAssetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAssetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAsset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAssetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAssetResult createAssetResult = (CreateAssetResult)response.getAwsResponse();
            return createAssetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePackagingConfigurationResult createPackagingConfiguration(CreatePackagingConfigurationRequest request) {
        request = (CreatePackagingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeCreatePackagingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePackagingConfigurationResult executeCreatePackagingConfiguration(CreatePackagingConfigurationRequest createPackagingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPackagingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePackagingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePackagingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((CreatePackagingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPackagingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePackagingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePackagingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePackagingConfigurationResult createPackagingConfigurationResult = (CreatePackagingConfigurationResult)response.getAwsResponse();
            return createPackagingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePackagingGroupResult createPackagingGroup(CreatePackagingGroupRequest request) {
        request = (CreatePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executeCreatePackagingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePackagingGroupResult executeCreatePackagingGroup(CreatePackagingGroupRequest createPackagingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPackagingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePackagingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePackagingGroupRequestProtocolMarshaller(protocolFactory).marshall((CreatePackagingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPackagingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePackagingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePackagingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePackagingGroupResult createPackagingGroupResult = (CreatePackagingGroupResult)response.getAwsResponse();
            return createPackagingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAssetResult deleteAsset(DeleteAssetRequest request) {
        request = (DeleteAssetRequest)this.beforeClientExecution(request);
        return this.executeDeleteAsset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAssetResult executeDeleteAsset(DeleteAssetRequest deleteAssetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssetRequestProtocolMarshaller(protocolFactory).marshall((DeleteAssetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAsset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAssetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssetResult deleteAssetResult = (DeleteAssetResult)response.getAwsResponse();
            return deleteAssetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePackagingConfigurationResult deletePackagingConfiguration(DeletePackagingConfigurationRequest request) {
        request = (DeletePackagingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDeletePackagingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePackagingConfigurationResult executeDeletePackagingConfiguration(DeletePackagingConfigurationRequest deletePackagingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePackagingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePackagingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePackagingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DeletePackagingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePackagingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePackagingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePackagingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePackagingConfigurationResult deletePackagingConfigurationResult = (DeletePackagingConfigurationResult)response.getAwsResponse();
            return deletePackagingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePackagingGroupResult deletePackagingGroup(DeletePackagingGroupRequest request) {
        request = (DeletePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executeDeletePackagingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePackagingGroupResult executeDeletePackagingGroup(DeletePackagingGroupRequest deletePackagingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePackagingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePackagingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePackagingGroupRequestProtocolMarshaller(protocolFactory).marshall((DeletePackagingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePackagingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePackagingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePackagingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePackagingGroupResult deletePackagingGroupResult = (DeletePackagingGroupResult)response.getAwsResponse();
            return deletePackagingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAssetResult describeAsset(DescribeAssetRequest request) {
        request = (DescribeAssetRequest)this.beforeClientExecution(request);
        return this.executeDescribeAsset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAssetResult executeDescribeAsset(DescribeAssetRequest describeAssetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAssetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAssetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAssetRequestProtocolMarshaller(protocolFactory).marshall((DescribeAssetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAssetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeAsset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAssetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAssetResult describeAssetResult = (DescribeAssetResult)response.getAwsResponse();
            return describeAssetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePackagingConfigurationResult describePackagingConfiguration(DescribePackagingConfigurationRequest request) {
        request = (DescribePackagingConfigurationRequest)this.beforeClientExecution(request);
        return this.executeDescribePackagingConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePackagingConfigurationResult executeDescribePackagingConfiguration(DescribePackagingConfigurationRequest describePackagingConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePackagingConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePackagingConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePackagingConfigurationRequestProtocolMarshaller(protocolFactory).marshall((DescribePackagingConfigurationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePackagingConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribePackagingConfiguration");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePackagingConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePackagingConfigurationResult describePackagingConfigurationResult = (DescribePackagingConfigurationResult)response.getAwsResponse();
            return describePackagingConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePackagingGroupResult describePackagingGroup(DescribePackagingGroupRequest request) {
        request = (DescribePackagingGroupRequest)this.beforeClientExecution(request);
        return this.executeDescribePackagingGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePackagingGroupResult executeDescribePackagingGroup(DescribePackagingGroupRequest describePackagingGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePackagingGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePackagingGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePackagingGroupRequestProtocolMarshaller(protocolFactory).marshall((DescribePackagingGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePackagingGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribePackagingGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePackagingGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePackagingGroupResult describePackagingGroupResult = (DescribePackagingGroupResult)response.getAwsResponse();
            return describePackagingGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAssetsResult listAssets(ListAssetsRequest request) {
        request = (ListAssetsRequest)this.beforeClientExecution(request);
        return this.executeListAssets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAssetsResult executeListAssets(ListAssetsRequest listAssetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAssetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAssetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAssetsRequestProtocolMarshaller(protocolFactory).marshall((ListAssetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAssetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAssets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAssetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAssetsResult listAssetsResult = (ListAssetsResult)response.getAwsResponse();
            return listAssetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPackagingConfigurationsResult listPackagingConfigurations(ListPackagingConfigurationsRequest request) {
        request = (ListPackagingConfigurationsRequest)this.beforeClientExecution(request);
        return this.executeListPackagingConfigurations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPackagingConfigurationsResult executeListPackagingConfigurations(ListPackagingConfigurationsRequest listPackagingConfigurationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPackagingConfigurationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPackagingConfigurationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPackagingConfigurationsRequestProtocolMarshaller(protocolFactory).marshall((ListPackagingConfigurationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPackagingConfigurationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPackagingConfigurations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPackagingConfigurationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPackagingConfigurationsResult listPackagingConfigurationsResult = (ListPackagingConfigurationsResult)response.getAwsResponse();
            return listPackagingConfigurationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPackagingGroupsResult listPackagingGroups(ListPackagingGroupsRequest request) {
        request = (ListPackagingGroupsRequest)this.beforeClientExecution(request);
        return this.executeListPackagingGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPackagingGroupsResult executeListPackagingGroups(ListPackagingGroupsRequest listPackagingGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPackagingGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPackagingGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPackagingGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListPackagingGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPackagingGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage Vod");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPackagingGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPackagingGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPackagingGroupsResult listPackagingGroupsResult = (ListPackagingGroupsResult)response.getAwsResponse();
            return listPackagingGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

