/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastoredata;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediastoredata.AWSMediaStoreData;
import com.amazonaws.services.mediastoredata.AWSMediaStoreDataClientBuilder;
import com.amazonaws.services.mediastoredata.model.AWSMediaStoreDataException;
import com.amazonaws.services.mediastoredata.model.DeleteObjectRequest;
import com.amazonaws.services.mediastoredata.model.DeleteObjectResult;
import com.amazonaws.services.mediastoredata.model.DescribeObjectRequest;
import com.amazonaws.services.mediastoredata.model.DescribeObjectResult;
import com.amazonaws.services.mediastoredata.model.GetObjectRequest;
import com.amazonaws.services.mediastoredata.model.GetObjectResult;
import com.amazonaws.services.mediastoredata.model.ListItemsRequest;
import com.amazonaws.services.mediastoredata.model.ListItemsResult;
import com.amazonaws.services.mediastoredata.model.PutObjectRequest;
import com.amazonaws.services.mediastoredata.model.PutObjectResult;
import com.amazonaws.services.mediastoredata.model.transform.ContainerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.DeleteObjectRequestProtocolMarshaller;
import com.amazonaws.services.mediastoredata.model.transform.DeleteObjectResultJsonUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.DescribeObjectRequestProtocolMarshaller;
import com.amazonaws.services.mediastoredata.model.transform.DescribeObjectResultJsonUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.GetObjectRequestProtocolMarshaller;
import com.amazonaws.services.mediastoredata.model.transform.GetObjectResultJsonUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.ListItemsRequestProtocolMarshaller;
import com.amazonaws.services.mediastoredata.model.transform.ListItemsResultJsonUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.ObjectNotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.PutObjectRequestProtocolMarshaller;
import com.amazonaws.services.mediastoredata.model.transform.PutObjectResultJsonUnmarshaller;
import com.amazonaws.services.mediastoredata.model.transform.RequestedRangeNotSatisfiableExceptionUnmarshaller;
import com.amazonaws.transform.JsonBaseExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaStoreDataClient
extends AmazonWebServiceClient
implements AWSMediaStoreData {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaStoreData.class);
    private static final String DEFAULT_SIGNING_NAME = "mediastore";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestedRangeNotSatisfiableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)RequestedRangeNotSatisfiableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ObjectNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ObjectNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContainerNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ContainerNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode(null).withExceptionUnmarshaller((JsonErrorUnmarshaller)new JsonBaseExceptionUnmarshaller(AWSMediaStoreDataException.class))));

    public static AWSMediaStoreDataClientBuilder builder() {
        return AWSMediaStoreDataClientBuilder.standard();
    }

    AWSMediaStoreDataClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaStoreDataClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("data.mediastore");
        this.setEndpoint("data.mediastore.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediastoredata/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediastoredata/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) {
        request = (DeleteObjectRequest)this.beforeClientExecution(request);
        return this.executeDeleteObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteObjectResult executeDeleteObject(DeleteObjectRequest deleteObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteObjectRequestProtocolMarshaller(protocolFactory).marshall((DeleteObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteObjectResult deleteObjectResult = (DeleteObjectResult)response.getAwsResponse();
            return deleteObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeObjectResult describeObject(DescribeObjectRequest request) {
        request = (DescribeObjectRequest)this.beforeClientExecution(request);
        return this.executeDescribeObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeObjectResult executeDescribeObject(DescribeObjectRequest describeObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeObjectRequestProtocolMarshaller(protocolFactory).marshall((DescribeObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeObjectResult describeObjectResult = (DescribeObjectResult)response.getAwsResponse();
            return describeObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) {
        request = (GetObjectRequest)this.beforeClientExecution(request);
        return this.executeGetObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetObjectResult executeGetObject(GetObjectRequest getObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetObjectRequestProtocolMarshaller(protocolFactory).marshall((GetObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)getObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(false).withHasStreamingSuccessResponse(true), (Unmarshaller)new GetObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetObjectResult getObjectResult = (GetObjectResult)response.getAwsResponse();
            return getObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListItemsResult listItems(ListItemsRequest request) {
        request = (ListItemsRequest)this.beforeClientExecution(request);
        return this.executeListItems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListItemsResult executeListItems(ListItemsRequest listItemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listItemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListItemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListItemsRequestProtocolMarshaller(protocolFactory).marshall((ListItemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listItemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListItems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListItemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListItemsResult listItemsResult = (ListItemsResult)response.getAwsResponse();
            return listItemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) {
        request = (PutObjectRequest)this.beforeClientExecution(request);
        return this.executePutObject(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutObjectResult executePutObject(PutObjectRequest putObjectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putObjectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutObjectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutObjectRequestProtocolMarshaller(protocolFactory).marshall((PutObjectRequest)super.beforeMarshalling((AmazonWebServiceRequest)putObjectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore Data");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutObject");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
                request.addHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT, (Object)Boolean.TRUE);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutObjectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutObjectResult putObjectResult = (PutObjectResult)response.getAwsResponse();
            return putObjectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

