/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediatailor.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediatailor-2018-04-23/CreateVodSource" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateVodSourceResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN to assign to this VOD source.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The time the VOD source was created.
     * </p>
     */
    private java.util.Date creationTime;
    /**
     * <p>
     * A list of HTTP package configuration parameters for this VOD source.
     * </p>
     */
    private java.util.List<HttpPackageConfiguration> httpPackageConfigurations;
    /**
     * <p>
     * The time the VOD source was last modified.
     * </p>
     */
    private java.util.Date lastModifiedTime;
    /**
     * <p>
     * The name to assign to the source location for this VOD source.
     * </p>
     */
    private String sourceLocationName;
    /**
     * <p>
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to
     * help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * The name to assign to the VOD source.
     * </p>
     */
    private String vodSourceName;

    /**
     * <p>
     * The ARN to assign to this VOD source.
     * </p>
     * 
     * @param arn
     *        The ARN to assign to this VOD source.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN to assign to this VOD source.
     * </p>
     * 
     * @return The ARN to assign to this VOD source.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN to assign to this VOD source.
     * </p>
     * 
     * @param arn
     *        The ARN to assign to this VOD source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The time the VOD source was created.
     * </p>
     * 
     * @param creationTime
     *        The time the VOD source was created.
     */

    public void setCreationTime(java.util.Date creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * <p>
     * The time the VOD source was created.
     * </p>
     * 
     * @return The time the VOD source was created.
     */

    public java.util.Date getCreationTime() {
        return this.creationTime;
    }

    /**
     * <p>
     * The time the VOD source was created.
     * </p>
     * 
     * @param creationTime
     *        The time the VOD source was created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withCreationTime(java.util.Date creationTime) {
        setCreationTime(creationTime);
        return this;
    }

    /**
     * <p>
     * A list of HTTP package configuration parameters for this VOD source.
     * </p>
     * 
     * @return A list of HTTP package configuration parameters for this VOD source.
     */

    public java.util.List<HttpPackageConfiguration> getHttpPackageConfigurations() {
        return httpPackageConfigurations;
    }

    /**
     * <p>
     * A list of HTTP package configuration parameters for this VOD source.
     * </p>
     * 
     * @param httpPackageConfigurations
     *        A list of HTTP package configuration parameters for this VOD source.
     */

    public void setHttpPackageConfigurations(java.util.Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        if (httpPackageConfigurations == null) {
            this.httpPackageConfigurations = null;
            return;
        }

        this.httpPackageConfigurations = new java.util.ArrayList<HttpPackageConfiguration>(httpPackageConfigurations);
    }

    /**
     * <p>
     * A list of HTTP package configuration parameters for this VOD source.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setHttpPackageConfigurations(java.util.Collection)} or
     * {@link #withHttpPackageConfigurations(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param httpPackageConfigurations
     *        A list of HTTP package configuration parameters for this VOD source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withHttpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations) {
        if (this.httpPackageConfigurations == null) {
            setHttpPackageConfigurations(new java.util.ArrayList<HttpPackageConfiguration>(httpPackageConfigurations.length));
        }
        for (HttpPackageConfiguration ele : httpPackageConfigurations) {
            this.httpPackageConfigurations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of HTTP package configuration parameters for this VOD source.
     * </p>
     * 
     * @param httpPackageConfigurations
     *        A list of HTTP package configuration parameters for this VOD source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withHttpPackageConfigurations(java.util.Collection<HttpPackageConfiguration> httpPackageConfigurations) {
        setHttpPackageConfigurations(httpPackageConfigurations);
        return this;
    }

    /**
     * <p>
     * The time the VOD source was last modified.
     * </p>
     * 
     * @param lastModifiedTime
     *        The time the VOD source was last modified.
     */

    public void setLastModifiedTime(java.util.Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    /**
     * <p>
     * The time the VOD source was last modified.
     * </p>
     * 
     * @return The time the VOD source was last modified.
     */

    public java.util.Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * <p>
     * The time the VOD source was last modified.
     * </p>
     * 
     * @param lastModifiedTime
     *        The time the VOD source was last modified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withLastModifiedTime(java.util.Date lastModifiedTime) {
        setLastModifiedTime(lastModifiedTime);
        return this;
    }

    /**
     * <p>
     * The name to assign to the source location for this VOD source.
     * </p>
     * 
     * @param sourceLocationName
     *        The name to assign to the source location for this VOD source.
     */

    public void setSourceLocationName(String sourceLocationName) {
        this.sourceLocationName = sourceLocationName;
    }

    /**
     * <p>
     * The name to assign to the source location for this VOD source.
     * </p>
     * 
     * @return The name to assign to the source location for this VOD source.
     */

    public String getSourceLocationName() {
        return this.sourceLocationName;
    }

    /**
     * <p>
     * The name to assign to the source location for this VOD source.
     * </p>
     * 
     * @param sourceLocationName
     *        The name to assign to the source location for this VOD source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withSourceLocationName(String sourceLocationName) {
        setSourceLocationName(sourceLocationName);
        return this;
    }

    /**
     * <p>
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to
     * help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * 
     * @return The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon
     *         resources to help with organization, access control, and cost tracking. For more information, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *         Resources</a>.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to
     * help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * 
     * @param tags
     *        The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon
     *        resources to help with organization, access control, and cost tracking. For more information, see <a
     *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *        Resources</a>.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to
     * help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * 
     * @param tags
     *        The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon
     *        resources to help with organization, access control, and cost tracking. For more information, see <a
     *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *        Resources</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateVodSourceResult#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * The name to assign to the VOD source.
     * </p>
     * 
     * @param vodSourceName
     *        The name to assign to the VOD source.
     */

    public void setVodSourceName(String vodSourceName) {
        this.vodSourceName = vodSourceName;
    }

    /**
     * <p>
     * The name to assign to the VOD source.
     * </p>
     * 
     * @return The name to assign to the VOD source.
     */

    public String getVodSourceName() {
        return this.vodSourceName;
    }

    /**
     * <p>
     * The name to assign to the VOD source.
     * </p>
     * 
     * @param vodSourceName
     *        The name to assign to the VOD source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVodSourceResult withVodSourceName(String vodSourceName) {
        setVodSourceName(vodSourceName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getCreationTime() != null)
            sb.append("CreationTime: ").append(getCreationTime()).append(",");
        if (getHttpPackageConfigurations() != null)
            sb.append("HttpPackageConfigurations: ").append(getHttpPackageConfigurations()).append(",");
        if (getLastModifiedTime() != null)
            sb.append("LastModifiedTime: ").append(getLastModifiedTime()).append(",");
        if (getSourceLocationName() != null)
            sb.append("SourceLocationName: ").append(getSourceLocationName()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getVodSourceName() != null)
            sb.append("VodSourceName: ").append(getVodSourceName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateVodSourceResult == false)
            return false;
        CreateVodSourceResult other = (CreateVodSourceResult) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getCreationTime() == null ^ this.getCreationTime() == null)
            return false;
        if (other.getCreationTime() != null && other.getCreationTime().equals(this.getCreationTime()) == false)
            return false;
        if (other.getHttpPackageConfigurations() == null ^ this.getHttpPackageConfigurations() == null)
            return false;
        if (other.getHttpPackageConfigurations() != null && other.getHttpPackageConfigurations().equals(this.getHttpPackageConfigurations()) == false)
            return false;
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null)
            return false;
        if (other.getLastModifiedTime() != null && other.getLastModifiedTime().equals(this.getLastModifiedTime()) == false)
            return false;
        if (other.getSourceLocationName() == null ^ this.getSourceLocationName() == null)
            return false;
        if (other.getSourceLocationName() != null && other.getSourceLocationName().equals(this.getSourceLocationName()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getVodSourceName() == null ^ this.getVodSourceName() == null)
            return false;
        if (other.getVodSourceName() != null && other.getVodSourceName().equals(this.getVodSourceName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getCreationTime() == null) ? 0 : getCreationTime().hashCode());
        hashCode = prime * hashCode + ((getHttpPackageConfigurations() == null) ? 0 : getHttpPackageConfigurations().hashCode());
        hashCode = prime * hashCode + ((getLastModifiedTime() == null) ? 0 : getLastModifiedTime().hashCode());
        hashCode = prime * hashCode + ((getSourceLocationName() == null) ? 0 : getSourceLocationName().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getVodSourceName() == null) ? 0 : getVodSourceName().hashCode());
        return hashCode;
    }

    @Override
    public CreateVodSourceResult clone() {
        try {
            return (CreateVodSourceResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
