/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.Bumper;

@SdkInternalApi
public class BumperMarshaller {
    private static final MarshallingInfo<String> ENDURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndUrl").build();
    private static final MarshallingInfo<String> STARTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartUrl").build();
    private static final BumperMarshaller instance = new BumperMarshaller();

    public static BumperMarshaller getInstance() {
        return instance;
    }

    public void marshall(Bumper bumper, ProtocolMarshaller protocolMarshaller) {
        if (bumper == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)bumper.getEndUrl(), ENDURL_BINDING);
            protocolMarshaller.marshall((Object)bumper.getStartUrl(), STARTURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

