/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mgn.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartCutoverRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> sourceServerIDs;
    private Map<String, String> tags;

    public List<String> getSourceServerIDs() {
        return this.sourceServerIDs;
    }

    public void setSourceServerIDs(Collection<String> sourceServerIDs) {
        if (sourceServerIDs == null) {
            this.sourceServerIDs = null;
            return;
        }
        this.sourceServerIDs = new ArrayList<String>(sourceServerIDs);
    }

    public StartCutoverRequest withSourceServerIDs(String ... sourceServerIDs) {
        if (this.sourceServerIDs == null) {
            this.setSourceServerIDs(new ArrayList<String>(sourceServerIDs.length));
        }
        for (String ele : sourceServerIDs) {
            this.sourceServerIDs.add(ele);
        }
        return this;
    }

    public StartCutoverRequest withSourceServerIDs(Collection<String> sourceServerIDs) {
        this.setSourceServerIDs(sourceServerIDs);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public StartCutoverRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public StartCutoverRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public StartCutoverRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceServerIDs() != null) {
            sb.append("SourceServerIDs: ").append(this.getSourceServerIDs()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCutoverRequest)) {
            return false;
        }
        StartCutoverRequest other = (StartCutoverRequest)obj;
        if (other.getSourceServerIDs() == null ^ this.getSourceServerIDs() == null) {
            return false;
        }
        if (other.getSourceServerIDs() != null && !other.getSourceServerIDs().equals(this.getSourceServerIDs())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceServerIDs() == null ? 0 : this.getSourceServerIDs().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartCutoverRequest clone() {
        return (StartCutoverRequest)super.clone();
    }
}

