/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mgn.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.mgn.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeLaunchConfigurationTemplatesResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeLaunchConfigurationTemplatesResultJsonUnmarshaller implements
        Unmarshaller<DescribeLaunchConfigurationTemplatesResult, JsonUnmarshallerContext> {

    public DescribeLaunchConfigurationTemplatesResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeLaunchConfigurationTemplatesResult describeLaunchConfigurationTemplatesResult = new DescribeLaunchConfigurationTemplatesResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeLaunchConfigurationTemplatesResult;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("items", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeLaunchConfigurationTemplatesResult.setItems(new ListUnmarshaller<LaunchConfigurationTemplate>(
                            LaunchConfigurationTemplateJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("nextToken", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeLaunchConfigurationTemplatesResult.setNextToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeLaunchConfigurationTemplatesResult;
    }

    private static DescribeLaunchConfigurationTemplatesResultJsonUnmarshaller instance;

    public static DescribeLaunchConfigurationTemplatesResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeLaunchConfigurationTemplatesResultJsonUnmarshaller();
        return instance;
    }
}
