/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mgn.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mgn.model.SsmDocument;
import java.util.Map;

@SdkInternalApi
public class SsmDocumentMarshaller {
    private static final MarshallingInfo<String> ACTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionName").build();
    private static final MarshallingInfo<Map> EXTERNALPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("externalParameters").build();
    private static final MarshallingInfo<Boolean> MUSTSUCCEEDFORCUTOVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mustSucceedForCutover").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<String> SSMDOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ssmDocumentName").build();
    private static final MarshallingInfo<Integer> TIMEOUTSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutSeconds").build();
    private static final SsmDocumentMarshaller instance = new SsmDocumentMarshaller();

    public static SsmDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(SsmDocument ssmDocument, ProtocolMarshaller protocolMarshaller) {
        if (ssmDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ssmDocument.getActionName(), ACTIONNAME_BINDING);
            protocolMarshaller.marshall(ssmDocument.getExternalParameters(), EXTERNALPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)ssmDocument.getMustSucceedForCutover(), MUSTSUCCEEDFORCUTOVER_BINDING);
            protocolMarshaller.marshall(ssmDocument.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)ssmDocument.getSsmDocumentName(), SSMDOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)ssmDocument.getTimeoutSeconds(), TIMEOUTSECONDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

