/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mgn.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * List imports request filters.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportsRequestFilters" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListImportsRequestFilters implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * List imports request filters import IDs.
     * </p>
     */
    private java.util.List<String> importIDs;

    /**
     * <p>
     * List imports request filters import IDs.
     * </p>
     * 
     * @return List imports request filters import IDs.
     */

    public java.util.List<String> getImportIDs() {
        return importIDs;
    }

    /**
     * <p>
     * List imports request filters import IDs.
     * </p>
     * 
     * @param importIDs
     *        List imports request filters import IDs.
     */

    public void setImportIDs(java.util.Collection<String> importIDs) {
        if (importIDs == null) {
            this.importIDs = null;
            return;
        }

        this.importIDs = new java.util.ArrayList<String>(importIDs);
    }

    /**
     * <p>
     * List imports request filters import IDs.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setImportIDs(java.util.Collection)} or {@link #withImportIDs(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param importIDs
     *        List imports request filters import IDs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListImportsRequestFilters withImportIDs(String... importIDs) {
        if (this.importIDs == null) {
            setImportIDs(new java.util.ArrayList<String>(importIDs.length));
        }
        for (String ele : importIDs) {
            this.importIDs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List imports request filters import IDs.
     * </p>
     * 
     * @param importIDs
     *        List imports request filters import IDs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListImportsRequestFilters withImportIDs(java.util.Collection<String> importIDs) {
        setImportIDs(importIDs);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getImportIDs() != null)
            sb.append("ImportIDs: ").append(getImportIDs());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListImportsRequestFilters == false)
            return false;
        ListImportsRequestFilters other = (ListImportsRequestFilters) obj;
        if (other.getImportIDs() == null ^ this.getImportIDs() == null)
            return false;
        if (other.getImportIDs() != null && other.getImportIDs().equals(this.getImportIDs()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getImportIDs() == null) ? 0 : getImportIDs().hashCode());
        return hashCode;
    }

    @Override
    public ListImportsRequestFilters clone() {
        try {
            return (ListImportsRequestFilters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mgn.model.transform.ListImportsRequestFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
