/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.migrationhub.model.ApplicationState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListApplicationStatesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ApplicationState> applicationStateList;
    private String nextToken;

    public List<ApplicationState> getApplicationStateList() {
        return this.applicationStateList;
    }

    public void setApplicationStateList(Collection<ApplicationState> applicationStateList) {
        if (applicationStateList == null) {
            this.applicationStateList = null;
            return;
        }
        this.applicationStateList = new ArrayList<ApplicationState>(applicationStateList);
    }

    public ListApplicationStatesResult withApplicationStateList(ApplicationState ... applicationStateList) {
        if (this.applicationStateList == null) {
            this.setApplicationStateList(new ArrayList<ApplicationState>(applicationStateList.length));
        }
        for (ApplicationState ele : applicationStateList) {
            this.applicationStateList.add(ele);
        }
        return this;
    }

    public ListApplicationStatesResult withApplicationStateList(Collection<ApplicationState> applicationStateList) {
        this.setApplicationStateList(applicationStateList);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListApplicationStatesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationStateList() != null) {
            sb.append("ApplicationStateList: ").append(this.getApplicationStateList()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationStatesResult)) {
            return false;
        }
        ListApplicationStatesResult other = (ListApplicationStatesResult)obj;
        if (other.getApplicationStateList() == null ^ this.getApplicationStateList() == null) {
            return false;
        }
        if (other.getApplicationStateList() != null && !other.getApplicationStateList().equals(this.getApplicationStateList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationStateList() == null ? 0 : this.getApplicationStateList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListApplicationStatesResult clone() {
        try {
            return (ListApplicationStatesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

