/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/StartAssessment"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartAssessmentRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     */
    private String s3bucketForAnalysisData;
    /**
     * <p>
     * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     */
    private String s3bucketForReportData;

    /**
     * <p>
     * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @param s3bucketForAnalysisData
     *        The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     *        <code>migrationhub-strategy-</code>.
     */

    public void setS3bucketForAnalysisData(String s3bucketForAnalysisData) {
        this.s3bucketForAnalysisData = s3bucketForAnalysisData;
    }

    /**
     * <p>
     * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin
     *         with <code>migrationhub-strategy-</code>.
     */

    public String getS3bucketForAnalysisData() {
        return this.s3bucketForAnalysisData;
    }

    /**
     * <p>
     * The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @param s3bucketForAnalysisData
     *        The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with
     *        <code>migrationhub-strategy-</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartAssessmentRequest withS3bucketForAnalysisData(String s3bucketForAnalysisData) {
        setS3bucketForAnalysisData(s3bucketForAnalysisData);
        return this;
    }

    /**
     * <p>
     * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @param s3bucketForReportData
     *        The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     *        <code>migrationhub-strategy-</code>.
     */

    public void setS3bucketForReportData(String s3bucketForReportData) {
        this.s3bucketForReportData = s3bucketForReportData;
    }

    /**
     * <p>
     * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @return The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     *         <code>migrationhub-strategy-</code>.
     */

    public String getS3bucketForReportData() {
        return this.s3bucketForReportData;
    }

    /**
     * <p>
     * The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     * <code>migrationhub-strategy-</code>.
     * </p>
     * 
     * @param s3bucketForReportData
     *        The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with
     *        <code>migrationhub-strategy-</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartAssessmentRequest withS3bucketForReportData(String s3bucketForReportData) {
        setS3bucketForReportData(s3bucketForReportData);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getS3bucketForAnalysisData() != null)
            sb.append("S3bucketForAnalysisData: ").append(getS3bucketForAnalysisData()).append(",");
        if (getS3bucketForReportData() != null)
            sb.append("S3bucketForReportData: ").append(getS3bucketForReportData());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartAssessmentRequest == false)
            return false;
        StartAssessmentRequest other = (StartAssessmentRequest) obj;
        if (other.getS3bucketForAnalysisData() == null ^ this.getS3bucketForAnalysisData() == null)
            return false;
        if (other.getS3bucketForAnalysisData() != null && other.getS3bucketForAnalysisData().equals(this.getS3bucketForAnalysisData()) == false)
            return false;
        if (other.getS3bucketForReportData() == null ^ this.getS3bucketForReportData() == null)
            return false;
        if (other.getS3bucketForReportData() != null && other.getS3bucketForReportData().equals(this.getS3bucketForReportData()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getS3bucketForAnalysisData() == null) ? 0 : getS3bucketForAnalysisData().hashCode());
        hashCode = prime * hashCode + ((getS3bucketForReportData() == null) ? 0 : getS3bucketForReportData().hashCode());
        return hashCode;
    }

    @Override
    public StartAssessmentRequest clone() {
        return (StartAssessmentRequest) super.clone();
    }

}
