/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.migrationhubstrategyrecommendations.model.transform.S3ObjectMarshaller;
import java.io.Serializable;

public class S3Object
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Bucket;
    private String s3key;

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public S3Object withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3key(String s3key) {
        this.s3key = s3key;
    }

    public String getS3key() {
        return this.s3key;
    }

    public S3Object withS3key(String s3key) {
        this.setS3key(s3key);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3key() != null) {
            sb.append("S3key: ").append(this.getS3key());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Object)) {
            return false;
        }
        S3Object other = (S3Object)obj;
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3key() == null ^ this.getS3key() == null) {
            return false;
        }
        return other.getS3key() == null || other.getS3key().equals(this.getS3key());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3key() == null ? 0 : this.getS3key().hashCode());
        return hashCode;
    }

    public S3Object clone() {
        try {
            return (S3Object)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

