/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.migrationhubstrategyrecommendations.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Summary information about an analyzable server.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/migrationhubstrategy-2020-02-19/AnalyzableServerSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AnalyzableServerSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The host name of the analyzable server.
     * </p>
     */
    private String hostname;
    /**
     * <p>
     * The ip address of the analyzable server.
     * </p>
     */
    private String ipAddress;
    /**
     * <p>
     * The data source of the analyzable server.
     * </p>
     */
    private String source;
    /**
     * <p>
     * The virtual machine id of the analyzable server.
     * </p>
     */
    private String vmId;

    /**
     * <p>
     * The host name of the analyzable server.
     * </p>
     * 
     * @param hostname
     *        The host name of the analyzable server.
     */

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    /**
     * <p>
     * The host name of the analyzable server.
     * </p>
     * 
     * @return The host name of the analyzable server.
     */

    public String getHostname() {
        return this.hostname;
    }

    /**
     * <p>
     * The host name of the analyzable server.
     * </p>
     * 
     * @param hostname
     *        The host name of the analyzable server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AnalyzableServerSummary withHostname(String hostname) {
        setHostname(hostname);
        return this;
    }

    /**
     * <p>
     * The ip address of the analyzable server.
     * </p>
     * 
     * @param ipAddress
     *        The ip address of the analyzable server.
     */

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * <p>
     * The ip address of the analyzable server.
     * </p>
     * 
     * @return The ip address of the analyzable server.
     */

    public String getIpAddress() {
        return this.ipAddress;
    }

    /**
     * <p>
     * The ip address of the analyzable server.
     * </p>
     * 
     * @param ipAddress
     *        The ip address of the analyzable server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AnalyzableServerSummary withIpAddress(String ipAddress) {
        setIpAddress(ipAddress);
        return this;
    }

    /**
     * <p>
     * The data source of the analyzable server.
     * </p>
     * 
     * @param source
     *        The data source of the analyzable server.
     */

    public void setSource(String source) {
        this.source = source;
    }

    /**
     * <p>
     * The data source of the analyzable server.
     * </p>
     * 
     * @return The data source of the analyzable server.
     */

    public String getSource() {
        return this.source;
    }

    /**
     * <p>
     * The data source of the analyzable server.
     * </p>
     * 
     * @param source
     *        The data source of the analyzable server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AnalyzableServerSummary withSource(String source) {
        setSource(source);
        return this;
    }

    /**
     * <p>
     * The virtual machine id of the analyzable server.
     * </p>
     * 
     * @param vmId
     *        The virtual machine id of the analyzable server.
     */

    public void setVmId(String vmId) {
        this.vmId = vmId;
    }

    /**
     * <p>
     * The virtual machine id of the analyzable server.
     * </p>
     * 
     * @return The virtual machine id of the analyzable server.
     */

    public String getVmId() {
        return this.vmId;
    }

    /**
     * <p>
     * The virtual machine id of the analyzable server.
     * </p>
     * 
     * @param vmId
     *        The virtual machine id of the analyzable server.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AnalyzableServerSummary withVmId(String vmId) {
        setVmId(vmId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getHostname() != null)
            sb.append("Hostname: ").append(getHostname()).append(",");
        if (getIpAddress() != null)
            sb.append("IpAddress: ").append(getIpAddress()).append(",");
        if (getSource() != null)
            sb.append("Source: ").append(getSource()).append(",");
        if (getVmId() != null)
            sb.append("VmId: ").append(getVmId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AnalyzableServerSummary == false)
            return false;
        AnalyzableServerSummary other = (AnalyzableServerSummary) obj;
        if (other.getHostname() == null ^ this.getHostname() == null)
            return false;
        if (other.getHostname() != null && other.getHostname().equals(this.getHostname()) == false)
            return false;
        if (other.getIpAddress() == null ^ this.getIpAddress() == null)
            return false;
        if (other.getIpAddress() != null && other.getIpAddress().equals(this.getIpAddress()) == false)
            return false;
        if (other.getSource() == null ^ this.getSource() == null)
            return false;
        if (other.getSource() != null && other.getSource().equals(this.getSource()) == false)
            return false;
        if (other.getVmId() == null ^ this.getVmId() == null)
            return false;
        if (other.getVmId() != null && other.getVmId().equals(this.getVmId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getHostname() == null) ? 0 : getHostname().hashCode());
        hashCode = prime * hashCode + ((getIpAddress() == null) ? 0 : getIpAddress().hashCode());
        hashCode = prime * hashCode + ((getSource() == null) ? 0 : getSource().hashCode());
        hashCode = prime * hashCode + ((getVmId() == null) ? 0 : getVmId().hashCode());
        return hashCode;
    }

    @Override
    public AnalyzableServerSummary clone() {
        try {
            return (AnalyzableServerSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.migrationhubstrategyrecommendations.model.transform.AnalyzableServerSummaryMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
