/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CancelOpenCypherQueryResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The cancellation status of the openCypher query.
     * </p>
     */
    private String status;
    /**
     * <p>
     * The cancelation payload for the openCypher query.
     * </p>
     */
    private Boolean payload;

    /**
     * <p>
     * The cancellation status of the openCypher query.
     * </p>
     * 
     * @param status
     *        The cancellation status of the openCypher query.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The cancellation status of the openCypher query.
     * </p>
     * 
     * @return The cancellation status of the openCypher query.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The cancellation status of the openCypher query.
     * </p>
     * 
     * @param status
     *        The cancellation status of the openCypher query.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CancelOpenCypherQueryResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The cancelation payload for the openCypher query.
     * </p>
     * 
     * @param payload
     *        The cancelation payload for the openCypher query.
     */

    public void setPayload(Boolean payload) {
        this.payload = payload;
    }

    /**
     * <p>
     * The cancelation payload for the openCypher query.
     * </p>
     * 
     * @return The cancelation payload for the openCypher query.
     */

    public Boolean getPayload() {
        return this.payload;
    }

    /**
     * <p>
     * The cancelation payload for the openCypher query.
     * </p>
     * 
     * @param payload
     *        The cancelation payload for the openCypher query.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CancelOpenCypherQueryResult withPayload(Boolean payload) {
        setPayload(payload);
        return this;
    }

    /**
     * <p>
     * The cancelation payload for the openCypher query.
     * </p>
     * 
     * @return The cancelation payload for the openCypher query.
     */

    public Boolean isPayload() {
        return this.payload;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getPayload() != null)
            sb.append("Payload: ").append(getPayload());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CancelOpenCypherQueryResult == false)
            return false;
        CancelOpenCypherQueryResult other = (CancelOpenCypherQueryResult) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getPayload() == null ^ this.getPayload() == null)
            return false;
        if (other.getPayload() != null && other.getPayload().equals(this.getPayload()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getPayload() == null) ? 0 : getPayload().hashCode());
        return hashCode;
    }

    @Override
    public CancelOpenCypherQueryResult clone() {
        try {
            return (CancelOpenCypherQueryResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
