/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.neptunedata.model.SubjectStructure;
import com.amazonaws.services.neptunedata.model.transform.RDFGraphSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class RDFGraphSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private Long numDistinctSubjects;
    private Long numDistinctPredicates;
    private Long numQuads;
    private Long numClasses;
    private List<String> classes;
    private List<Map<String, Long>> predicates;
    private List<SubjectStructure> subjectStructures;

    public void setNumDistinctSubjects(Long numDistinctSubjects) {
        this.numDistinctSubjects = numDistinctSubjects;
    }

    public Long getNumDistinctSubjects() {
        return this.numDistinctSubjects;
    }

    public RDFGraphSummary withNumDistinctSubjects(Long numDistinctSubjects) {
        this.setNumDistinctSubjects(numDistinctSubjects);
        return this;
    }

    public void setNumDistinctPredicates(Long numDistinctPredicates) {
        this.numDistinctPredicates = numDistinctPredicates;
    }

    public Long getNumDistinctPredicates() {
        return this.numDistinctPredicates;
    }

    public RDFGraphSummary withNumDistinctPredicates(Long numDistinctPredicates) {
        this.setNumDistinctPredicates(numDistinctPredicates);
        return this;
    }

    public void setNumQuads(Long numQuads) {
        this.numQuads = numQuads;
    }

    public Long getNumQuads() {
        return this.numQuads;
    }

    public RDFGraphSummary withNumQuads(Long numQuads) {
        this.setNumQuads(numQuads);
        return this;
    }

    public void setNumClasses(Long numClasses) {
        this.numClasses = numClasses;
    }

    public Long getNumClasses() {
        return this.numClasses;
    }

    public RDFGraphSummary withNumClasses(Long numClasses) {
        this.setNumClasses(numClasses);
        return this;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(Collection<String> classes) {
        if (classes == null) {
            this.classes = null;
            return;
        }
        this.classes = new ArrayList<String>(classes);
    }

    public RDFGraphSummary withClasses(String ... classes) {
        if (this.classes == null) {
            this.setClasses(new ArrayList<String>(classes.length));
        }
        for (String ele : classes) {
            this.classes.add(ele);
        }
        return this;
    }

    public RDFGraphSummary withClasses(Collection<String> classes) {
        this.setClasses(classes);
        return this;
    }

    public List<Map<String, Long>> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(Collection<Map<String, Long>> predicates) {
        if (predicates == null) {
            this.predicates = null;
            return;
        }
        this.predicates = new ArrayList<Map<String, Long>>(predicates);
    }

    public RDFGraphSummary withPredicates(Map<String, Long> ... predicates) {
        if (this.predicates == null) {
            this.setPredicates(new ArrayList<Map<String, Long>>(predicates.length));
        }
        for (Map<String, Long> ele : predicates) {
            this.predicates.add(ele);
        }
        return this;
    }

    public RDFGraphSummary withPredicates(Collection<Map<String, Long>> predicates) {
        this.setPredicates(predicates);
        return this;
    }

    public List<SubjectStructure> getSubjectStructures() {
        return this.subjectStructures;
    }

    public void setSubjectStructures(Collection<SubjectStructure> subjectStructures) {
        if (subjectStructures == null) {
            this.subjectStructures = null;
            return;
        }
        this.subjectStructures = new ArrayList<SubjectStructure>(subjectStructures);
    }

    public RDFGraphSummary withSubjectStructures(SubjectStructure ... subjectStructures) {
        if (this.subjectStructures == null) {
            this.setSubjectStructures(new ArrayList<SubjectStructure>(subjectStructures.length));
        }
        for (SubjectStructure ele : subjectStructures) {
            this.subjectStructures.add(ele);
        }
        return this;
    }

    public RDFGraphSummary withSubjectStructures(Collection<SubjectStructure> subjectStructures) {
        this.setSubjectStructures(subjectStructures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNumDistinctSubjects() != null) {
            sb.append("NumDistinctSubjects: ").append(this.getNumDistinctSubjects()).append(",");
        }
        if (this.getNumDistinctPredicates() != null) {
            sb.append("NumDistinctPredicates: ").append(this.getNumDistinctPredicates()).append(",");
        }
        if (this.getNumQuads() != null) {
            sb.append("NumQuads: ").append(this.getNumQuads()).append(",");
        }
        if (this.getNumClasses() != null) {
            sb.append("NumClasses: ").append(this.getNumClasses()).append(",");
        }
        if (this.getClasses() != null) {
            sb.append("Classes: ").append(this.getClasses()).append(",");
        }
        if (this.getPredicates() != null) {
            sb.append("Predicates: ").append(this.getPredicates()).append(",");
        }
        if (this.getSubjectStructures() != null) {
            sb.append("SubjectStructures: ").append(this.getSubjectStructures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDFGraphSummary)) {
            return false;
        }
        RDFGraphSummary other = (RDFGraphSummary)obj;
        if (other.getNumDistinctSubjects() == null ^ this.getNumDistinctSubjects() == null) {
            return false;
        }
        if (other.getNumDistinctSubjects() != null && !other.getNumDistinctSubjects().equals(this.getNumDistinctSubjects())) {
            return false;
        }
        if (other.getNumDistinctPredicates() == null ^ this.getNumDistinctPredicates() == null) {
            return false;
        }
        if (other.getNumDistinctPredicates() != null && !other.getNumDistinctPredicates().equals(this.getNumDistinctPredicates())) {
            return false;
        }
        if (other.getNumQuads() == null ^ this.getNumQuads() == null) {
            return false;
        }
        if (other.getNumQuads() != null && !other.getNumQuads().equals(this.getNumQuads())) {
            return false;
        }
        if (other.getNumClasses() == null ^ this.getNumClasses() == null) {
            return false;
        }
        if (other.getNumClasses() != null && !other.getNumClasses().equals(this.getNumClasses())) {
            return false;
        }
        if (other.getClasses() == null ^ this.getClasses() == null) {
            return false;
        }
        if (other.getClasses() != null && !other.getClasses().equals(this.getClasses())) {
            return false;
        }
        if (other.getPredicates() == null ^ this.getPredicates() == null) {
            return false;
        }
        if (other.getPredicates() != null && !other.getPredicates().equals(this.getPredicates())) {
            return false;
        }
        if (other.getSubjectStructures() == null ^ this.getSubjectStructures() == null) {
            return false;
        }
        return other.getSubjectStructures() == null || other.getSubjectStructures().equals(this.getSubjectStructures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNumDistinctSubjects() == null ? 0 : this.getNumDistinctSubjects().hashCode());
        hashCode = 31 * hashCode + (this.getNumDistinctPredicates() == null ? 0 : this.getNumDistinctPredicates().hashCode());
        hashCode = 31 * hashCode + (this.getNumQuads() == null ? 0 : this.getNumQuads().hashCode());
        hashCode = 31 * hashCode + (this.getNumClasses() == null ? 0 : this.getNumClasses().hashCode());
        hashCode = 31 * hashCode + (this.getClasses() == null ? 0 : this.getClasses().hashCode());
        hashCode = 31 * hashCode + (this.getPredicates() == null ? 0 : this.getPredicates().hashCode());
        hashCode = 31 * hashCode + (this.getSubjectStructures() == null ? 0 : this.getSubjectStructures().hashCode());
        return hashCode;
    }

    public RDFGraphSummary clone() {
        try {
            return (RDFGraphSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RDFGraphSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

