/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkfirewall.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Configures one or more IP set references for a Suricata-compatible rule group. This is used in <a>CreateRuleGroup</a>
 * or <a>UpdateRuleGroup</a>. An IP set reference is a rule variable that references resources that you create and
 * manage in another Amazon Web Services service, such as an Amazon VPC prefix list. Network Firewall IP set references
 * enable you to dynamically update the contents of your rules. When you create, update, or delete the resource you are
 * referencing in your rule, Network Firewall automatically updates the rule's content with the changes. For more
 * information about IP set references in Network Firewall, see <a
 * href="https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references">Using IP set
 * references</a> in the <i>Network Firewall Developer Guide</i>.
 * </p>
 * <p>
 * Network Firewall currently supports <a
 * href="https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html">Amazon VPC prefix lists</a> and <a
 * href=
 * "https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-referencing-resource-groups"
 * >resource groups</a> in IP set references.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/network-firewall-2020-11-12/IPSetReference" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IPSetReference implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     * </p>
     */
    private String referenceArn;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     * </p>
     * 
     * @param referenceArn
     *        The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     */

    public void setReferenceArn(String referenceArn) {
        this.referenceArn = referenceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     */

    public String getReferenceArn() {
        return this.referenceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     * </p>
     * 
     * @param referenceArn
     *        The Amazon Resource Name (ARN) of the resource that you are referencing in your rule group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IPSetReference withReferenceArn(String referenceArn) {
        setReferenceArn(referenceArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReferenceArn() != null)
            sb.append("ReferenceArn: ").append(getReferenceArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IPSetReference == false)
            return false;
        IPSetReference other = (IPSetReference) obj;
        if (other.getReferenceArn() == null ^ this.getReferenceArn() == null)
            return false;
        if (other.getReferenceArn() != null && other.getReferenceArn().equals(this.getReferenceArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReferenceArn() == null) ? 0 : getReferenceArn().hashCode());
        return hashCode;
    }

    @Override
    public IPSetReference clone() {
        try {
            return (IPSetReference) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.networkfirewall.model.transform.IPSetReferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
