/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkmanager;

import javax.annotation.Generated;

import com.amazonaws.services.networkmanager.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSNetworkManager}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSNetworkManager implements AWSNetworkManager {

    protected AbstractAWSNetworkManager() {
    }

    @Override
    public AssociateCustomerGatewayResult associateCustomerGateway(AssociateCustomerGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateLinkResult associateLink(AssociateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeviceResult createDevice(CreateDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGlobalNetworkResult createGlobalNetwork(CreateGlobalNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLinkResult createLink(CreateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSiteResult createSite(CreateSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceResult deleteDevice(DeleteDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGlobalNetworkResult deleteGlobalNetwork(DeleteGlobalNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLinkResult deleteLink(DeleteLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSiteResult deleteSite(DeleteSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterTransitGatewayResult deregisterTransitGateway(DeregisterTransitGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGlobalNetworksResult describeGlobalNetworks(DescribeGlobalNetworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateCustomerGatewayResult disassociateCustomerGateway(DisassociateCustomerGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateLinkResult disassociateLink(DisassociateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCustomerGatewayAssociationsResult getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevicesResult getDevices(GetDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLinkAssociationsResult getLinkAssociations(GetLinkAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLinksResult getLinks(GetLinksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSitesResult getSites(GetSitesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransitGatewayRegistrationsResult getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterTransitGatewayResult registerTransitGateway(RegisterTransitGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceResult updateDevice(UpdateDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlobalNetworkResult updateGlobalNetwork(UpdateGlobalNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLinkResult updateLink(UpdateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSiteResult updateSite(UpdateSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
