/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.networkmanager.AWSNetworkManagerAsync;
import com.amazonaws.services.networkmanager.AWSNetworkManagerAsyncClientBuilder;
import com.amazonaws.services.networkmanager.AWSNetworkManagerClient;
import com.amazonaws.services.networkmanager.model.AssociateCustomerGatewayRequest;
import com.amazonaws.services.networkmanager.model.AssociateCustomerGatewayResult;
import com.amazonaws.services.networkmanager.model.AssociateLinkRequest;
import com.amazonaws.services.networkmanager.model.AssociateLinkResult;
import com.amazonaws.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest;
import com.amazonaws.services.networkmanager.model.AssociateTransitGatewayConnectPeerResult;
import com.amazonaws.services.networkmanager.model.CreateConnectionRequest;
import com.amazonaws.services.networkmanager.model.CreateConnectionResult;
import com.amazonaws.services.networkmanager.model.CreateDeviceRequest;
import com.amazonaws.services.networkmanager.model.CreateDeviceResult;
import com.amazonaws.services.networkmanager.model.CreateGlobalNetworkRequest;
import com.amazonaws.services.networkmanager.model.CreateGlobalNetworkResult;
import com.amazonaws.services.networkmanager.model.CreateLinkRequest;
import com.amazonaws.services.networkmanager.model.CreateLinkResult;
import com.amazonaws.services.networkmanager.model.CreateSiteRequest;
import com.amazonaws.services.networkmanager.model.CreateSiteResult;
import com.amazonaws.services.networkmanager.model.DeleteConnectionRequest;
import com.amazonaws.services.networkmanager.model.DeleteConnectionResult;
import com.amazonaws.services.networkmanager.model.DeleteDeviceRequest;
import com.amazonaws.services.networkmanager.model.DeleteDeviceResult;
import com.amazonaws.services.networkmanager.model.DeleteGlobalNetworkRequest;
import com.amazonaws.services.networkmanager.model.DeleteGlobalNetworkResult;
import com.amazonaws.services.networkmanager.model.DeleteLinkRequest;
import com.amazonaws.services.networkmanager.model.DeleteLinkResult;
import com.amazonaws.services.networkmanager.model.DeleteSiteRequest;
import com.amazonaws.services.networkmanager.model.DeleteSiteResult;
import com.amazonaws.services.networkmanager.model.DeregisterTransitGatewayRequest;
import com.amazonaws.services.networkmanager.model.DeregisterTransitGatewayResult;
import com.amazonaws.services.networkmanager.model.DescribeGlobalNetworksRequest;
import com.amazonaws.services.networkmanager.model.DescribeGlobalNetworksResult;
import com.amazonaws.services.networkmanager.model.DisassociateCustomerGatewayRequest;
import com.amazonaws.services.networkmanager.model.DisassociateCustomerGatewayResult;
import com.amazonaws.services.networkmanager.model.DisassociateLinkRequest;
import com.amazonaws.services.networkmanager.model.DisassociateLinkResult;
import com.amazonaws.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest;
import com.amazonaws.services.networkmanager.model.DisassociateTransitGatewayConnectPeerResult;
import com.amazonaws.services.networkmanager.model.GetConnectionsRequest;
import com.amazonaws.services.networkmanager.model.GetConnectionsResult;
import com.amazonaws.services.networkmanager.model.GetCustomerGatewayAssociationsRequest;
import com.amazonaws.services.networkmanager.model.GetCustomerGatewayAssociationsResult;
import com.amazonaws.services.networkmanager.model.GetDevicesRequest;
import com.amazonaws.services.networkmanager.model.GetDevicesResult;
import com.amazonaws.services.networkmanager.model.GetLinkAssociationsRequest;
import com.amazonaws.services.networkmanager.model.GetLinkAssociationsResult;
import com.amazonaws.services.networkmanager.model.GetLinksRequest;
import com.amazonaws.services.networkmanager.model.GetLinksResult;
import com.amazonaws.services.networkmanager.model.GetNetworkResourceCountsRequest;
import com.amazonaws.services.networkmanager.model.GetNetworkResourceCountsResult;
import com.amazonaws.services.networkmanager.model.GetNetworkResourceRelationshipsRequest;
import com.amazonaws.services.networkmanager.model.GetNetworkResourceRelationshipsResult;
import com.amazonaws.services.networkmanager.model.GetNetworkResourcesRequest;
import com.amazonaws.services.networkmanager.model.GetNetworkResourcesResult;
import com.amazonaws.services.networkmanager.model.GetNetworkRoutesRequest;
import com.amazonaws.services.networkmanager.model.GetNetworkRoutesResult;
import com.amazonaws.services.networkmanager.model.GetNetworkTelemetryRequest;
import com.amazonaws.services.networkmanager.model.GetNetworkTelemetryResult;
import com.amazonaws.services.networkmanager.model.GetRouteAnalysisRequest;
import com.amazonaws.services.networkmanager.model.GetRouteAnalysisResult;
import com.amazonaws.services.networkmanager.model.GetSitesRequest;
import com.amazonaws.services.networkmanager.model.GetSitesResult;
import com.amazonaws.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest;
import com.amazonaws.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResult;
import com.amazonaws.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import com.amazonaws.services.networkmanager.model.GetTransitGatewayRegistrationsResult;
import com.amazonaws.services.networkmanager.model.ListTagsForResourceRequest;
import com.amazonaws.services.networkmanager.model.ListTagsForResourceResult;
import com.amazonaws.services.networkmanager.model.RegisterTransitGatewayRequest;
import com.amazonaws.services.networkmanager.model.RegisterTransitGatewayResult;
import com.amazonaws.services.networkmanager.model.StartRouteAnalysisRequest;
import com.amazonaws.services.networkmanager.model.StartRouteAnalysisResult;
import com.amazonaws.services.networkmanager.model.TagResourceRequest;
import com.amazonaws.services.networkmanager.model.TagResourceResult;
import com.amazonaws.services.networkmanager.model.UntagResourceRequest;
import com.amazonaws.services.networkmanager.model.UntagResourceResult;
import com.amazonaws.services.networkmanager.model.UpdateConnectionRequest;
import com.amazonaws.services.networkmanager.model.UpdateConnectionResult;
import com.amazonaws.services.networkmanager.model.UpdateDeviceRequest;
import com.amazonaws.services.networkmanager.model.UpdateDeviceResult;
import com.amazonaws.services.networkmanager.model.UpdateGlobalNetworkRequest;
import com.amazonaws.services.networkmanager.model.UpdateGlobalNetworkResult;
import com.amazonaws.services.networkmanager.model.UpdateLinkRequest;
import com.amazonaws.services.networkmanager.model.UpdateLinkResult;
import com.amazonaws.services.networkmanager.model.UpdateNetworkResourceMetadataRequest;
import com.amazonaws.services.networkmanager.model.UpdateNetworkResourceMetadataResult;
import com.amazonaws.services.networkmanager.model.UpdateSiteRequest;
import com.amazonaws.services.networkmanager.model.UpdateSiteResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSNetworkManagerAsyncClient
extends AWSNetworkManagerClient
implements AWSNetworkManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSNetworkManagerAsyncClientBuilder asyncBuilder() {
        return AWSNetworkManagerAsyncClientBuilder.standard();
    }

    AWSNetworkManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSNetworkManagerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateCustomerGatewayResult> associateCustomerGatewayAsync(AssociateCustomerGatewayRequest request) {
        return this.associateCustomerGatewayAsync(request, null);
    }

    @Override
    public Future<AssociateCustomerGatewayResult> associateCustomerGatewayAsync(AssociateCustomerGatewayRequest request, final AsyncHandler<AssociateCustomerGatewayRequest, AssociateCustomerGatewayResult> asyncHandler) {
        final AssociateCustomerGatewayRequest finalRequest = (AssociateCustomerGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateCustomerGatewayResult>(){

            @Override
            public AssociateCustomerGatewayResult call() throws Exception {
                AssociateCustomerGatewayResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeAssociateCustomerGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateLinkResult> associateLinkAsync(AssociateLinkRequest request) {
        return this.associateLinkAsync(request, null);
    }

    @Override
    public Future<AssociateLinkResult> associateLinkAsync(AssociateLinkRequest request, final AsyncHandler<AssociateLinkRequest, AssociateLinkResult> asyncHandler) {
        final AssociateLinkRequest finalRequest = (AssociateLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateLinkResult>(){

            @Override
            public AssociateLinkResult call() throws Exception {
                AssociateLinkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeAssociateLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateTransitGatewayConnectPeerResult> associateTransitGatewayConnectPeerAsync(AssociateTransitGatewayConnectPeerRequest request) {
        return this.associateTransitGatewayConnectPeerAsync(request, null);
    }

    @Override
    public Future<AssociateTransitGatewayConnectPeerResult> associateTransitGatewayConnectPeerAsync(AssociateTransitGatewayConnectPeerRequest request, final AsyncHandler<AssociateTransitGatewayConnectPeerRequest, AssociateTransitGatewayConnectPeerResult> asyncHandler) {
        final AssociateTransitGatewayConnectPeerRequest finalRequest = (AssociateTransitGatewayConnectPeerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateTransitGatewayConnectPeerResult>(){

            @Override
            public AssociateTransitGatewayConnectPeerResult call() throws Exception {
                AssociateTransitGatewayConnectPeerResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeAssociateTransitGatewayConnectPeer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request) {
        return this.createConnectionAsync(request, null);
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request, final AsyncHandler<CreateConnectionRequest, CreateConnectionResult> asyncHandler) {
        final CreateConnectionRequest finalRequest = (CreateConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConnectionResult>(){

            @Override
            public CreateConnectionResult call() throws Exception {
                CreateConnectionResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeCreateConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDeviceResult> createDeviceAsync(CreateDeviceRequest request) {
        return this.createDeviceAsync(request, null);
    }

    @Override
    public Future<CreateDeviceResult> createDeviceAsync(CreateDeviceRequest request, final AsyncHandler<CreateDeviceRequest, CreateDeviceResult> asyncHandler) {
        final CreateDeviceRequest finalRequest = (CreateDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDeviceResult>(){

            @Override
            public CreateDeviceResult call() throws Exception {
                CreateDeviceResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeCreateDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGlobalNetworkResult> createGlobalNetworkAsync(CreateGlobalNetworkRequest request) {
        return this.createGlobalNetworkAsync(request, null);
    }

    @Override
    public Future<CreateGlobalNetworkResult> createGlobalNetworkAsync(CreateGlobalNetworkRequest request, final AsyncHandler<CreateGlobalNetworkRequest, CreateGlobalNetworkResult> asyncHandler) {
        final CreateGlobalNetworkRequest finalRequest = (CreateGlobalNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGlobalNetworkResult>(){

            @Override
            public CreateGlobalNetworkResult call() throws Exception {
                CreateGlobalNetworkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeCreateGlobalNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLinkResult> createLinkAsync(CreateLinkRequest request) {
        return this.createLinkAsync(request, null);
    }

    @Override
    public Future<CreateLinkResult> createLinkAsync(CreateLinkRequest request, final AsyncHandler<CreateLinkRequest, CreateLinkResult> asyncHandler) {
        final CreateLinkRequest finalRequest = (CreateLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLinkResult>(){

            @Override
            public CreateLinkResult call() throws Exception {
                CreateLinkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeCreateLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request) {
        return this.createSiteAsync(request, null);
    }

    @Override
    public Future<CreateSiteResult> createSiteAsync(CreateSiteRequest request, final AsyncHandler<CreateSiteRequest, CreateSiteResult> asyncHandler) {
        final CreateSiteRequest finalRequest = (CreateSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSiteResult>(){

            @Override
            public CreateSiteResult call() throws Exception {
                CreateSiteResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeCreateSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request, final AsyncHandler<DeleteConnectionRequest, DeleteConnectionResult> asyncHandler) {
        final DeleteConnectionRequest finalRequest = (DeleteConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                DeleteConnectionResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDeleteConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDeviceResult> deleteDeviceAsync(DeleteDeviceRequest request) {
        return this.deleteDeviceAsync(request, null);
    }

    @Override
    public Future<DeleteDeviceResult> deleteDeviceAsync(DeleteDeviceRequest request, final AsyncHandler<DeleteDeviceRequest, DeleteDeviceResult> asyncHandler) {
        final DeleteDeviceRequest finalRequest = (DeleteDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDeviceResult>(){

            @Override
            public DeleteDeviceResult call() throws Exception {
                DeleteDeviceResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDeleteDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGlobalNetworkResult> deleteGlobalNetworkAsync(DeleteGlobalNetworkRequest request) {
        return this.deleteGlobalNetworkAsync(request, null);
    }

    @Override
    public Future<DeleteGlobalNetworkResult> deleteGlobalNetworkAsync(DeleteGlobalNetworkRequest request, final AsyncHandler<DeleteGlobalNetworkRequest, DeleteGlobalNetworkResult> asyncHandler) {
        final DeleteGlobalNetworkRequest finalRequest = (DeleteGlobalNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGlobalNetworkResult>(){

            @Override
            public DeleteGlobalNetworkResult call() throws Exception {
                DeleteGlobalNetworkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDeleteGlobalNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLinkResult> deleteLinkAsync(DeleteLinkRequest request) {
        return this.deleteLinkAsync(request, null);
    }

    @Override
    public Future<DeleteLinkResult> deleteLinkAsync(DeleteLinkRequest request, final AsyncHandler<DeleteLinkRequest, DeleteLinkResult> asyncHandler) {
        final DeleteLinkRequest finalRequest = (DeleteLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLinkResult>(){

            @Override
            public DeleteLinkResult call() throws Exception {
                DeleteLinkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDeleteLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request) {
        return this.deleteSiteAsync(request, null);
    }

    @Override
    public Future<DeleteSiteResult> deleteSiteAsync(DeleteSiteRequest request, final AsyncHandler<DeleteSiteRequest, DeleteSiteResult> asyncHandler) {
        final DeleteSiteRequest finalRequest = (DeleteSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSiteResult>(){

            @Override
            public DeleteSiteResult call() throws Exception {
                DeleteSiteResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDeleteSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterTransitGatewayResult> deregisterTransitGatewayAsync(DeregisterTransitGatewayRequest request) {
        return this.deregisterTransitGatewayAsync(request, null);
    }

    @Override
    public Future<DeregisterTransitGatewayResult> deregisterTransitGatewayAsync(DeregisterTransitGatewayRequest request, final AsyncHandler<DeregisterTransitGatewayRequest, DeregisterTransitGatewayResult> asyncHandler) {
        final DeregisterTransitGatewayRequest finalRequest = (DeregisterTransitGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterTransitGatewayResult>(){

            @Override
            public DeregisterTransitGatewayResult call() throws Exception {
                DeregisterTransitGatewayResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDeregisterTransitGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeGlobalNetworksResult> describeGlobalNetworksAsync(DescribeGlobalNetworksRequest request) {
        return this.describeGlobalNetworksAsync(request, null);
    }

    @Override
    public Future<DescribeGlobalNetworksResult> describeGlobalNetworksAsync(DescribeGlobalNetworksRequest request, final AsyncHandler<DescribeGlobalNetworksRequest, DescribeGlobalNetworksResult> asyncHandler) {
        final DescribeGlobalNetworksRequest finalRequest = (DescribeGlobalNetworksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeGlobalNetworksResult>(){

            @Override
            public DescribeGlobalNetworksResult call() throws Exception {
                DescribeGlobalNetworksResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDescribeGlobalNetworks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateCustomerGatewayResult> disassociateCustomerGatewayAsync(DisassociateCustomerGatewayRequest request) {
        return this.disassociateCustomerGatewayAsync(request, null);
    }

    @Override
    public Future<DisassociateCustomerGatewayResult> disassociateCustomerGatewayAsync(DisassociateCustomerGatewayRequest request, final AsyncHandler<DisassociateCustomerGatewayRequest, DisassociateCustomerGatewayResult> asyncHandler) {
        final DisassociateCustomerGatewayRequest finalRequest = (DisassociateCustomerGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateCustomerGatewayResult>(){

            @Override
            public DisassociateCustomerGatewayResult call() throws Exception {
                DisassociateCustomerGatewayResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDisassociateCustomerGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateLinkResult> disassociateLinkAsync(DisassociateLinkRequest request) {
        return this.disassociateLinkAsync(request, null);
    }

    @Override
    public Future<DisassociateLinkResult> disassociateLinkAsync(DisassociateLinkRequest request, final AsyncHandler<DisassociateLinkRequest, DisassociateLinkResult> asyncHandler) {
        final DisassociateLinkRequest finalRequest = (DisassociateLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateLinkResult>(){

            @Override
            public DisassociateLinkResult call() throws Exception {
                DisassociateLinkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDisassociateLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateTransitGatewayConnectPeerResult> disassociateTransitGatewayConnectPeerAsync(DisassociateTransitGatewayConnectPeerRequest request) {
        return this.disassociateTransitGatewayConnectPeerAsync(request, null);
    }

    @Override
    public Future<DisassociateTransitGatewayConnectPeerResult> disassociateTransitGatewayConnectPeerAsync(DisassociateTransitGatewayConnectPeerRequest request, final AsyncHandler<DisassociateTransitGatewayConnectPeerRequest, DisassociateTransitGatewayConnectPeerResult> asyncHandler) {
        final DisassociateTransitGatewayConnectPeerRequest finalRequest = (DisassociateTransitGatewayConnectPeerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateTransitGatewayConnectPeerResult>(){

            @Override
            public DisassociateTransitGatewayConnectPeerResult call() throws Exception {
                DisassociateTransitGatewayConnectPeerResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeDisassociateTransitGatewayConnectPeer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetConnectionsResult> getConnectionsAsync(GetConnectionsRequest request) {
        return this.getConnectionsAsync(request, null);
    }

    @Override
    public Future<GetConnectionsResult> getConnectionsAsync(GetConnectionsRequest request, final AsyncHandler<GetConnectionsRequest, GetConnectionsResult> asyncHandler) {
        final GetConnectionsRequest finalRequest = (GetConnectionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetConnectionsResult>(){

            @Override
            public GetConnectionsResult call() throws Exception {
                GetConnectionsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetConnections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCustomerGatewayAssociationsResult> getCustomerGatewayAssociationsAsync(GetCustomerGatewayAssociationsRequest request) {
        return this.getCustomerGatewayAssociationsAsync(request, null);
    }

    @Override
    public Future<GetCustomerGatewayAssociationsResult> getCustomerGatewayAssociationsAsync(GetCustomerGatewayAssociationsRequest request, final AsyncHandler<GetCustomerGatewayAssociationsRequest, GetCustomerGatewayAssociationsResult> asyncHandler) {
        final GetCustomerGatewayAssociationsRequest finalRequest = (GetCustomerGatewayAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCustomerGatewayAssociationsResult>(){

            @Override
            public GetCustomerGatewayAssociationsResult call() throws Exception {
                GetCustomerGatewayAssociationsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetCustomerGatewayAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDevicesResult> getDevicesAsync(GetDevicesRequest request) {
        return this.getDevicesAsync(request, null);
    }

    @Override
    public Future<GetDevicesResult> getDevicesAsync(GetDevicesRequest request, final AsyncHandler<GetDevicesRequest, GetDevicesResult> asyncHandler) {
        final GetDevicesRequest finalRequest = (GetDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDevicesResult>(){

            @Override
            public GetDevicesResult call() throws Exception {
                GetDevicesResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLinkAssociationsResult> getLinkAssociationsAsync(GetLinkAssociationsRequest request) {
        return this.getLinkAssociationsAsync(request, null);
    }

    @Override
    public Future<GetLinkAssociationsResult> getLinkAssociationsAsync(GetLinkAssociationsRequest request, final AsyncHandler<GetLinkAssociationsRequest, GetLinkAssociationsResult> asyncHandler) {
        final GetLinkAssociationsRequest finalRequest = (GetLinkAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLinkAssociationsResult>(){

            @Override
            public GetLinkAssociationsResult call() throws Exception {
                GetLinkAssociationsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetLinkAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLinksResult> getLinksAsync(GetLinksRequest request) {
        return this.getLinksAsync(request, null);
    }

    @Override
    public Future<GetLinksResult> getLinksAsync(GetLinksRequest request, final AsyncHandler<GetLinksRequest, GetLinksResult> asyncHandler) {
        final GetLinksRequest finalRequest = (GetLinksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLinksResult>(){

            @Override
            public GetLinksResult call() throws Exception {
                GetLinksResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetLinks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkResourceCountsResult> getNetworkResourceCountsAsync(GetNetworkResourceCountsRequest request) {
        return this.getNetworkResourceCountsAsync(request, null);
    }

    @Override
    public Future<GetNetworkResourceCountsResult> getNetworkResourceCountsAsync(GetNetworkResourceCountsRequest request, final AsyncHandler<GetNetworkResourceCountsRequest, GetNetworkResourceCountsResult> asyncHandler) {
        final GetNetworkResourceCountsRequest finalRequest = (GetNetworkResourceCountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkResourceCountsResult>(){

            @Override
            public GetNetworkResourceCountsResult call() throws Exception {
                GetNetworkResourceCountsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetNetworkResourceCounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkResourceRelationshipsResult> getNetworkResourceRelationshipsAsync(GetNetworkResourceRelationshipsRequest request) {
        return this.getNetworkResourceRelationshipsAsync(request, null);
    }

    @Override
    public Future<GetNetworkResourceRelationshipsResult> getNetworkResourceRelationshipsAsync(GetNetworkResourceRelationshipsRequest request, final AsyncHandler<GetNetworkResourceRelationshipsRequest, GetNetworkResourceRelationshipsResult> asyncHandler) {
        final GetNetworkResourceRelationshipsRequest finalRequest = (GetNetworkResourceRelationshipsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkResourceRelationshipsResult>(){

            @Override
            public GetNetworkResourceRelationshipsResult call() throws Exception {
                GetNetworkResourceRelationshipsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetNetworkResourceRelationships(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkResourcesResult> getNetworkResourcesAsync(GetNetworkResourcesRequest request) {
        return this.getNetworkResourcesAsync(request, null);
    }

    @Override
    public Future<GetNetworkResourcesResult> getNetworkResourcesAsync(GetNetworkResourcesRequest request, final AsyncHandler<GetNetworkResourcesRequest, GetNetworkResourcesResult> asyncHandler) {
        final GetNetworkResourcesRequest finalRequest = (GetNetworkResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkResourcesResult>(){

            @Override
            public GetNetworkResourcesResult call() throws Exception {
                GetNetworkResourcesResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetNetworkResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkRoutesResult> getNetworkRoutesAsync(GetNetworkRoutesRequest request) {
        return this.getNetworkRoutesAsync(request, null);
    }

    @Override
    public Future<GetNetworkRoutesResult> getNetworkRoutesAsync(GetNetworkRoutesRequest request, final AsyncHandler<GetNetworkRoutesRequest, GetNetworkRoutesResult> asyncHandler) {
        final GetNetworkRoutesRequest finalRequest = (GetNetworkRoutesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkRoutesResult>(){

            @Override
            public GetNetworkRoutesResult call() throws Exception {
                GetNetworkRoutesResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetNetworkRoutes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetNetworkTelemetryResult> getNetworkTelemetryAsync(GetNetworkTelemetryRequest request) {
        return this.getNetworkTelemetryAsync(request, null);
    }

    @Override
    public Future<GetNetworkTelemetryResult> getNetworkTelemetryAsync(GetNetworkTelemetryRequest request, final AsyncHandler<GetNetworkTelemetryRequest, GetNetworkTelemetryResult> asyncHandler) {
        final GetNetworkTelemetryRequest finalRequest = (GetNetworkTelemetryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetNetworkTelemetryResult>(){

            @Override
            public GetNetworkTelemetryResult call() throws Exception {
                GetNetworkTelemetryResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetNetworkTelemetry(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRouteAnalysisResult> getRouteAnalysisAsync(GetRouteAnalysisRequest request) {
        return this.getRouteAnalysisAsync(request, null);
    }

    @Override
    public Future<GetRouteAnalysisResult> getRouteAnalysisAsync(GetRouteAnalysisRequest request, final AsyncHandler<GetRouteAnalysisRequest, GetRouteAnalysisResult> asyncHandler) {
        final GetRouteAnalysisRequest finalRequest = (GetRouteAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRouteAnalysisResult>(){

            @Override
            public GetRouteAnalysisResult call() throws Exception {
                GetRouteAnalysisResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetRouteAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSitesResult> getSitesAsync(GetSitesRequest request) {
        return this.getSitesAsync(request, null);
    }

    @Override
    public Future<GetSitesResult> getSitesAsync(GetSitesRequest request, final AsyncHandler<GetSitesRequest, GetSitesResult> asyncHandler) {
        final GetSitesRequest finalRequest = (GetSitesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSitesResult>(){

            @Override
            public GetSitesResult call() throws Exception {
                GetSitesResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetSites(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTransitGatewayConnectPeerAssociationsResult> getTransitGatewayConnectPeerAssociationsAsync(GetTransitGatewayConnectPeerAssociationsRequest request) {
        return this.getTransitGatewayConnectPeerAssociationsAsync(request, null);
    }

    @Override
    public Future<GetTransitGatewayConnectPeerAssociationsResult> getTransitGatewayConnectPeerAssociationsAsync(GetTransitGatewayConnectPeerAssociationsRequest request, final AsyncHandler<GetTransitGatewayConnectPeerAssociationsRequest, GetTransitGatewayConnectPeerAssociationsResult> asyncHandler) {
        final GetTransitGatewayConnectPeerAssociationsRequest finalRequest = (GetTransitGatewayConnectPeerAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTransitGatewayConnectPeerAssociationsResult>(){

            @Override
            public GetTransitGatewayConnectPeerAssociationsResult call() throws Exception {
                GetTransitGatewayConnectPeerAssociationsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetTransitGatewayConnectPeerAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTransitGatewayRegistrationsResult> getTransitGatewayRegistrationsAsync(GetTransitGatewayRegistrationsRequest request) {
        return this.getTransitGatewayRegistrationsAsync(request, null);
    }

    @Override
    public Future<GetTransitGatewayRegistrationsResult> getTransitGatewayRegistrationsAsync(GetTransitGatewayRegistrationsRequest request, final AsyncHandler<GetTransitGatewayRegistrationsRequest, GetTransitGatewayRegistrationsResult> asyncHandler) {
        final GetTransitGatewayRegistrationsRequest finalRequest = (GetTransitGatewayRegistrationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTransitGatewayRegistrationsResult>(){

            @Override
            public GetTransitGatewayRegistrationsResult call() throws Exception {
                GetTransitGatewayRegistrationsResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeGetTransitGatewayRegistrations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterTransitGatewayResult> registerTransitGatewayAsync(RegisterTransitGatewayRequest request) {
        return this.registerTransitGatewayAsync(request, null);
    }

    @Override
    public Future<RegisterTransitGatewayResult> registerTransitGatewayAsync(RegisterTransitGatewayRequest request, final AsyncHandler<RegisterTransitGatewayRequest, RegisterTransitGatewayResult> asyncHandler) {
        final RegisterTransitGatewayRequest finalRequest = (RegisterTransitGatewayRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterTransitGatewayResult>(){

            @Override
            public RegisterTransitGatewayResult call() throws Exception {
                RegisterTransitGatewayResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeRegisterTransitGateway(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartRouteAnalysisResult> startRouteAnalysisAsync(StartRouteAnalysisRequest request) {
        return this.startRouteAnalysisAsync(request, null);
    }

    @Override
    public Future<StartRouteAnalysisResult> startRouteAnalysisAsync(StartRouteAnalysisRequest request, final AsyncHandler<StartRouteAnalysisRequest, StartRouteAnalysisResult> asyncHandler) {
        final StartRouteAnalysisRequest finalRequest = (StartRouteAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartRouteAnalysisResult>(){

            @Override
            public StartRouteAnalysisResult call() throws Exception {
                StartRouteAnalysisResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeStartRouteAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConnectionResult> updateConnectionAsync(UpdateConnectionRequest request) {
        return this.updateConnectionAsync(request, null);
    }

    @Override
    public Future<UpdateConnectionResult> updateConnectionAsync(UpdateConnectionRequest request, final AsyncHandler<UpdateConnectionRequest, UpdateConnectionResult> asyncHandler) {
        final UpdateConnectionRequest finalRequest = (UpdateConnectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConnectionResult>(){

            @Override
            public UpdateConnectionResult call() throws Exception {
                UpdateConnectionResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUpdateConnection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDeviceResult> updateDeviceAsync(UpdateDeviceRequest request) {
        return this.updateDeviceAsync(request, null);
    }

    @Override
    public Future<UpdateDeviceResult> updateDeviceAsync(UpdateDeviceRequest request, final AsyncHandler<UpdateDeviceRequest, UpdateDeviceResult> asyncHandler) {
        final UpdateDeviceRequest finalRequest = (UpdateDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDeviceResult>(){

            @Override
            public UpdateDeviceResult call() throws Exception {
                UpdateDeviceResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUpdateDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateGlobalNetworkResult> updateGlobalNetworkAsync(UpdateGlobalNetworkRequest request) {
        return this.updateGlobalNetworkAsync(request, null);
    }

    @Override
    public Future<UpdateGlobalNetworkResult> updateGlobalNetworkAsync(UpdateGlobalNetworkRequest request, final AsyncHandler<UpdateGlobalNetworkRequest, UpdateGlobalNetworkResult> asyncHandler) {
        final UpdateGlobalNetworkRequest finalRequest = (UpdateGlobalNetworkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateGlobalNetworkResult>(){

            @Override
            public UpdateGlobalNetworkResult call() throws Exception {
                UpdateGlobalNetworkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUpdateGlobalNetwork(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLinkResult> updateLinkAsync(UpdateLinkRequest request) {
        return this.updateLinkAsync(request, null);
    }

    @Override
    public Future<UpdateLinkResult> updateLinkAsync(UpdateLinkRequest request, final AsyncHandler<UpdateLinkRequest, UpdateLinkResult> asyncHandler) {
        final UpdateLinkRequest finalRequest = (UpdateLinkRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLinkResult>(){

            @Override
            public UpdateLinkResult call() throws Exception {
                UpdateLinkResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUpdateLink(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNetworkResourceMetadataResult> updateNetworkResourceMetadataAsync(UpdateNetworkResourceMetadataRequest request) {
        return this.updateNetworkResourceMetadataAsync(request, null);
    }

    @Override
    public Future<UpdateNetworkResourceMetadataResult> updateNetworkResourceMetadataAsync(UpdateNetworkResourceMetadataRequest request, final AsyncHandler<UpdateNetworkResourceMetadataRequest, UpdateNetworkResourceMetadataResult> asyncHandler) {
        final UpdateNetworkResourceMetadataRequest finalRequest = (UpdateNetworkResourceMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNetworkResourceMetadataResult>(){

            @Override
            public UpdateNetworkResourceMetadataResult call() throws Exception {
                UpdateNetworkResourceMetadataResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUpdateNetworkResourceMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request) {
        return this.updateSiteAsync(request, null);
    }

    @Override
    public Future<UpdateSiteResult> updateSiteAsync(UpdateSiteRequest request, final AsyncHandler<UpdateSiteRequest, UpdateSiteResult> asyncHandler) {
        final UpdateSiteRequest finalRequest = (UpdateSiteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSiteResult>(){

            @Override
            public UpdateSiteResult call() throws Exception {
                UpdateSiteResult result = null;
                try {
                    result = AWSNetworkManagerAsyncClient.this.executeUpdateSite(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

