/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.networkmanager.model.RouteState;
import com.amazonaws.services.networkmanager.model.RouteTableIdentifier;
import com.amazonaws.services.networkmanager.model.RouteType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetNetworkRoutesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String globalNetworkId;
    private RouteTableIdentifier routeTableIdentifier;
    private List<String> exactCidrMatches;
    private List<String> longestPrefixMatches;
    private List<String> subnetOfMatches;
    private List<String> supernetOfMatches;
    private List<String> prefixListIds;
    private List<String> states;
    private List<String> types;
    private Map<String, List<String>> destinationFilters;

    public void setGlobalNetworkId(String globalNetworkId) {
        this.globalNetworkId = globalNetworkId;
    }

    public String getGlobalNetworkId() {
        return this.globalNetworkId;
    }

    public GetNetworkRoutesRequest withGlobalNetworkId(String globalNetworkId) {
        this.setGlobalNetworkId(globalNetworkId);
        return this;
    }

    public void setRouteTableIdentifier(RouteTableIdentifier routeTableIdentifier) {
        this.routeTableIdentifier = routeTableIdentifier;
    }

    public RouteTableIdentifier getRouteTableIdentifier() {
        return this.routeTableIdentifier;
    }

    public GetNetworkRoutesRequest withRouteTableIdentifier(RouteTableIdentifier routeTableIdentifier) {
        this.setRouteTableIdentifier(routeTableIdentifier);
        return this;
    }

    public List<String> getExactCidrMatches() {
        return this.exactCidrMatches;
    }

    public void setExactCidrMatches(Collection<String> exactCidrMatches) {
        if (exactCidrMatches == null) {
            this.exactCidrMatches = null;
            return;
        }
        this.exactCidrMatches = new ArrayList<String>(exactCidrMatches);
    }

    public GetNetworkRoutesRequest withExactCidrMatches(String ... exactCidrMatches) {
        if (this.exactCidrMatches == null) {
            this.setExactCidrMatches(new ArrayList<String>(exactCidrMatches.length));
        }
        for (String ele : exactCidrMatches) {
            this.exactCidrMatches.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withExactCidrMatches(Collection<String> exactCidrMatches) {
        this.setExactCidrMatches(exactCidrMatches);
        return this;
    }

    public List<String> getLongestPrefixMatches() {
        return this.longestPrefixMatches;
    }

    public void setLongestPrefixMatches(Collection<String> longestPrefixMatches) {
        if (longestPrefixMatches == null) {
            this.longestPrefixMatches = null;
            return;
        }
        this.longestPrefixMatches = new ArrayList<String>(longestPrefixMatches);
    }

    public GetNetworkRoutesRequest withLongestPrefixMatches(String ... longestPrefixMatches) {
        if (this.longestPrefixMatches == null) {
            this.setLongestPrefixMatches(new ArrayList<String>(longestPrefixMatches.length));
        }
        for (String ele : longestPrefixMatches) {
            this.longestPrefixMatches.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withLongestPrefixMatches(Collection<String> longestPrefixMatches) {
        this.setLongestPrefixMatches(longestPrefixMatches);
        return this;
    }

    public List<String> getSubnetOfMatches() {
        return this.subnetOfMatches;
    }

    public void setSubnetOfMatches(Collection<String> subnetOfMatches) {
        if (subnetOfMatches == null) {
            this.subnetOfMatches = null;
            return;
        }
        this.subnetOfMatches = new ArrayList<String>(subnetOfMatches);
    }

    public GetNetworkRoutesRequest withSubnetOfMatches(String ... subnetOfMatches) {
        if (this.subnetOfMatches == null) {
            this.setSubnetOfMatches(new ArrayList<String>(subnetOfMatches.length));
        }
        for (String ele : subnetOfMatches) {
            this.subnetOfMatches.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withSubnetOfMatches(Collection<String> subnetOfMatches) {
        this.setSubnetOfMatches(subnetOfMatches);
        return this;
    }

    public List<String> getSupernetOfMatches() {
        return this.supernetOfMatches;
    }

    public void setSupernetOfMatches(Collection<String> supernetOfMatches) {
        if (supernetOfMatches == null) {
            this.supernetOfMatches = null;
            return;
        }
        this.supernetOfMatches = new ArrayList<String>(supernetOfMatches);
    }

    public GetNetworkRoutesRequest withSupernetOfMatches(String ... supernetOfMatches) {
        if (this.supernetOfMatches == null) {
            this.setSupernetOfMatches(new ArrayList<String>(supernetOfMatches.length));
        }
        for (String ele : supernetOfMatches) {
            this.supernetOfMatches.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withSupernetOfMatches(Collection<String> supernetOfMatches) {
        this.setSupernetOfMatches(supernetOfMatches);
        return this;
    }

    public List<String> getPrefixListIds() {
        return this.prefixListIds;
    }

    public void setPrefixListIds(Collection<String> prefixListIds) {
        if (prefixListIds == null) {
            this.prefixListIds = null;
            return;
        }
        this.prefixListIds = new ArrayList<String>(prefixListIds);
    }

    public GetNetworkRoutesRequest withPrefixListIds(String ... prefixListIds) {
        if (this.prefixListIds == null) {
            this.setPrefixListIds(new ArrayList<String>(prefixListIds.length));
        }
        for (String ele : prefixListIds) {
            this.prefixListIds.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withPrefixListIds(Collection<String> prefixListIds) {
        this.setPrefixListIds(prefixListIds);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public GetNetworkRoutesRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public GetNetworkRoutesRequest withStates(RouteState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (RouteState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }
        this.types = new ArrayList<String>(types);
    }

    public GetNetworkRoutesRequest withTypes(String ... types) {
        if (this.types == null) {
            this.setTypes(new ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    public GetNetworkRoutesRequest withTypes(Collection<String> types) {
        this.setTypes(types);
        return this;
    }

    public GetNetworkRoutesRequest withTypes(RouteType ... types) {
        ArrayList<String> typesCopy = new ArrayList<String>(types.length);
        for (RouteType value : types) {
            typesCopy.add(value.toString());
        }
        if (this.getTypes() == null) {
            this.setTypes(typesCopy);
        } else {
            this.getTypes().addAll(typesCopy);
        }
        return this;
    }

    public Map<String, List<String>> getDestinationFilters() {
        return this.destinationFilters;
    }

    public void setDestinationFilters(Map<String, List<String>> destinationFilters) {
        this.destinationFilters = destinationFilters;
    }

    public GetNetworkRoutesRequest withDestinationFilters(Map<String, List<String>> destinationFilters) {
        this.setDestinationFilters(destinationFilters);
        return this;
    }

    public GetNetworkRoutesRequest addDestinationFiltersEntry(String key, List<String> value) {
        if (null == this.destinationFilters) {
            this.destinationFilters = new HashMap<String, List<String>>();
        }
        if (this.destinationFilters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.destinationFilters.put(key, value);
        return this;
    }

    public GetNetworkRoutesRequest clearDestinationFiltersEntries() {
        this.destinationFilters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGlobalNetworkId() != null) {
            sb.append("GlobalNetworkId: ").append(this.getGlobalNetworkId()).append(",");
        }
        if (this.getRouteTableIdentifier() != null) {
            sb.append("RouteTableIdentifier: ").append(this.getRouteTableIdentifier()).append(",");
        }
        if (this.getExactCidrMatches() != null) {
            sb.append("ExactCidrMatches: ").append(this.getExactCidrMatches()).append(",");
        }
        if (this.getLongestPrefixMatches() != null) {
            sb.append("LongestPrefixMatches: ").append(this.getLongestPrefixMatches()).append(",");
        }
        if (this.getSubnetOfMatches() != null) {
            sb.append("SubnetOfMatches: ").append(this.getSubnetOfMatches()).append(",");
        }
        if (this.getSupernetOfMatches() != null) {
            sb.append("SupernetOfMatches: ").append(this.getSupernetOfMatches()).append(",");
        }
        if (this.getPrefixListIds() != null) {
            sb.append("PrefixListIds: ").append(this.getPrefixListIds()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getTypes() != null) {
            sb.append("Types: ").append(this.getTypes()).append(",");
        }
        if (this.getDestinationFilters() != null) {
            sb.append("DestinationFilters: ").append(this.getDestinationFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkRoutesRequest)) {
            return false;
        }
        GetNetworkRoutesRequest other = (GetNetworkRoutesRequest)obj;
        if (other.getGlobalNetworkId() == null ^ this.getGlobalNetworkId() == null) {
            return false;
        }
        if (other.getGlobalNetworkId() != null && !other.getGlobalNetworkId().equals(this.getGlobalNetworkId())) {
            return false;
        }
        if (other.getRouteTableIdentifier() == null ^ this.getRouteTableIdentifier() == null) {
            return false;
        }
        if (other.getRouteTableIdentifier() != null && !other.getRouteTableIdentifier().equals(this.getRouteTableIdentifier())) {
            return false;
        }
        if (other.getExactCidrMatches() == null ^ this.getExactCidrMatches() == null) {
            return false;
        }
        if (other.getExactCidrMatches() != null && !other.getExactCidrMatches().equals(this.getExactCidrMatches())) {
            return false;
        }
        if (other.getLongestPrefixMatches() == null ^ this.getLongestPrefixMatches() == null) {
            return false;
        }
        if (other.getLongestPrefixMatches() != null && !other.getLongestPrefixMatches().equals(this.getLongestPrefixMatches())) {
            return false;
        }
        if (other.getSubnetOfMatches() == null ^ this.getSubnetOfMatches() == null) {
            return false;
        }
        if (other.getSubnetOfMatches() != null && !other.getSubnetOfMatches().equals(this.getSubnetOfMatches())) {
            return false;
        }
        if (other.getSupernetOfMatches() == null ^ this.getSupernetOfMatches() == null) {
            return false;
        }
        if (other.getSupernetOfMatches() != null && !other.getSupernetOfMatches().equals(this.getSupernetOfMatches())) {
            return false;
        }
        if (other.getPrefixListIds() == null ^ this.getPrefixListIds() == null) {
            return false;
        }
        if (other.getPrefixListIds() != null && !other.getPrefixListIds().equals(this.getPrefixListIds())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getTypes() == null ^ this.getTypes() == null) {
            return false;
        }
        if (other.getTypes() != null && !other.getTypes().equals(this.getTypes())) {
            return false;
        }
        if (other.getDestinationFilters() == null ^ this.getDestinationFilters() == null) {
            return false;
        }
        return other.getDestinationFilters() == null || other.getDestinationFilters().equals(this.getDestinationFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGlobalNetworkId() == null ? 0 : this.getGlobalNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableIdentifier() == null ? 0 : this.getRouteTableIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getExactCidrMatches() == null ? 0 : this.getExactCidrMatches().hashCode());
        hashCode = 31 * hashCode + (this.getLongestPrefixMatches() == null ? 0 : this.getLongestPrefixMatches().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetOfMatches() == null ? 0 : this.getSubnetOfMatches().hashCode());
        hashCode = 31 * hashCode + (this.getSupernetOfMatches() == null ? 0 : this.getSupernetOfMatches().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixListIds() == null ? 0 : this.getPrefixListIds().hashCode());
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getTypes() == null ? 0 : this.getTypes().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationFilters() == null ? 0 : this.getDestinationFilters().hashCode());
        return hashCode;
    }

    public GetNetworkRoutesRequest clone() {
        return (GetNetworkRoutesRequest)super.clone();
    }
}

