/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.NetworkRouteDestination;
import com.amazonaws.services.networkmanager.model.RouteState;
import com.amazonaws.services.networkmanager.model.RouteType;
import com.amazonaws.services.networkmanager.model.transform.NetworkRouteMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkRoute
implements Serializable,
Cloneable,
StructuredPojo {
    private String destinationCidrBlock;
    private List<NetworkRouteDestination> destinations;
    private String prefixListId;
    private String state;
    private String type;

    public void setDestinationCidrBlock(String destinationCidrBlock) {
        this.destinationCidrBlock = destinationCidrBlock;
    }

    public String getDestinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public NetworkRoute withDestinationCidrBlock(String destinationCidrBlock) {
        this.setDestinationCidrBlock(destinationCidrBlock);
        return this;
    }

    public List<NetworkRouteDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<NetworkRouteDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<NetworkRouteDestination>(destinations);
    }

    public NetworkRoute withDestinations(NetworkRouteDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<NetworkRouteDestination>(destinations.length));
        }
        for (NetworkRouteDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public NetworkRoute withDestinations(Collection<NetworkRouteDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public void setPrefixListId(String prefixListId) {
        this.prefixListId = prefixListId;
    }

    public String getPrefixListId() {
        return this.prefixListId;
    }

    public NetworkRoute withPrefixListId(String prefixListId) {
        this.setPrefixListId(prefixListId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public NetworkRoute withState(String state) {
        this.setState(state);
        return this;
    }

    public NetworkRoute withState(RouteState state) {
        this.state = state.toString();
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public NetworkRoute withType(String type) {
        this.setType(type);
        return this;
    }

    public NetworkRoute withType(RouteType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(this.getDestinationCidrBlock()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getPrefixListId() != null) {
            sb.append("PrefixListId: ").append(this.getPrefixListId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkRoute)) {
            return false;
        }
        NetworkRoute other = (NetworkRoute)obj;
        if (other.getDestinationCidrBlock() == null ^ this.getDestinationCidrBlock() == null) {
            return false;
        }
        if (other.getDestinationCidrBlock() != null && !other.getDestinationCidrBlock().equals(this.getDestinationCidrBlock())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getPrefixListId() == null ^ this.getPrefixListId() == null) {
            return false;
        }
        if (other.getPrefixListId() != null && !other.getPrefixListId().equals(this.getPrefixListId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinationCidrBlock() == null ? 0 : this.getDestinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getPrefixListId() == null ? 0 : this.getPrefixListId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public NetworkRoute clone() {
        try {
            return (NetworkRoute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkRouteMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

