/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.networkmonitor.model.CreateMonitorProbeInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateMonitorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String monitorName;
    private List<CreateMonitorProbeInput> probes;
    private Long aggregationPeriod;
    private String clientToken;
    private Map<String, String> tags;

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public CreateMonitorRequest withMonitorName(String monitorName) {
        this.setMonitorName(monitorName);
        return this;
    }

    public List<CreateMonitorProbeInput> getProbes() {
        return this.probes;
    }

    public void setProbes(Collection<CreateMonitorProbeInput> probes) {
        if (probes == null) {
            this.probes = null;
            return;
        }
        this.probes = new ArrayList<CreateMonitorProbeInput>(probes);
    }

    public CreateMonitorRequest withProbes(CreateMonitorProbeInput ... probes) {
        if (this.probes == null) {
            this.setProbes(new ArrayList<CreateMonitorProbeInput>(probes.length));
        }
        for (CreateMonitorProbeInput ele : probes) {
            this.probes.add(ele);
        }
        return this;
    }

    public CreateMonitorRequest withProbes(Collection<CreateMonitorProbeInput> probes) {
        this.setProbes(probes);
        return this;
    }

    public void setAggregationPeriod(Long aggregationPeriod) {
        this.aggregationPeriod = aggregationPeriod;
    }

    public Long getAggregationPeriod() {
        return this.aggregationPeriod;
    }

    public CreateMonitorRequest withAggregationPeriod(Long aggregationPeriod) {
        this.setAggregationPeriod(aggregationPeriod);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateMonitorRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateMonitorRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateMonitorRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateMonitorRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitorName() != null) {
            sb.append("MonitorName: ").append(this.getMonitorName()).append(",");
        }
        if (this.getProbes() != null) {
            sb.append("Probes: ").append(this.getProbes()).append(",");
        }
        if (this.getAggregationPeriod() != null) {
            sb.append("AggregationPeriod: ").append(this.getAggregationPeriod()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorRequest)) {
            return false;
        }
        CreateMonitorRequest other = (CreateMonitorRequest)obj;
        if (other.getMonitorName() == null ^ this.getMonitorName() == null) {
            return false;
        }
        if (other.getMonitorName() != null && !other.getMonitorName().equals(this.getMonitorName())) {
            return false;
        }
        if (other.getProbes() == null ^ this.getProbes() == null) {
            return false;
        }
        if (other.getProbes() != null && !other.getProbes().equals(this.getProbes())) {
            return false;
        }
        if (other.getAggregationPeriod() == null ^ this.getAggregationPeriod() == null) {
            return false;
        }
        if (other.getAggregationPeriod() != null && !other.getAggregationPeriod().equals(this.getAggregationPeriod())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitorName() == null ? 0 : this.getMonitorName().hashCode());
        hashCode = 31 * hashCode + (this.getProbes() == null ? 0 : this.getProbes().hashCode());
        hashCode = 31 * hashCode + (this.getAggregationPeriod() == null ? 0 : this.getAggregationPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateMonitorRequest clone() {
        return (CreateMonitorRequest)super.clone();
    }
}

