/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmonitor.model.Protocol;
import com.amazonaws.services.networkmonitor.model.transform.ProbeInputMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ProbeInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceArn;
    private String destination;
    private Integer destinationPort;
    private String protocol;
    private Integer packetSize;
    private Map<String, String> tags;

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public ProbeInput withSourceArn(String sourceArn) {
        this.setSourceArn(sourceArn);
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public ProbeInput withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setDestinationPort(Integer destinationPort) {
        this.destinationPort = destinationPort;
    }

    public Integer getDestinationPort() {
        return this.destinationPort;
    }

    public ProbeInput withDestinationPort(Integer destinationPort) {
        this.setDestinationPort(destinationPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ProbeInput withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public ProbeInput withProtocol(Protocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setPacketSize(Integer packetSize) {
        this.packetSize = packetSize;
    }

    public Integer getPacketSize() {
        return this.packetSize;
    }

    public ProbeInput withPacketSize(Integer packetSize) {
        this.setPacketSize(packetSize);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ProbeInput withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ProbeInput addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ProbeInput clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: ").append(this.getSourceArn()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getDestinationPort() != null) {
            sb.append("DestinationPort: ").append(this.getDestinationPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getPacketSize() != null) {
            sb.append("PacketSize: ").append(this.getPacketSize()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbeInput)) {
            return false;
        }
        ProbeInput other = (ProbeInput)obj;
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getDestinationPort() == null ^ this.getDestinationPort() == null) {
            return false;
        }
        if (other.getDestinationPort() != null && !other.getDestinationPort().equals(this.getDestinationPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getPacketSize() == null ^ this.getPacketSize() == null) {
            return false;
        }
        if (other.getPacketSize() != null && !other.getPacketSize().equals(this.getPacketSize())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPort() == null ? 0 : this.getDestinationPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getPacketSize() == null ? 0 : this.getPacketSize().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ProbeInput clone() {
        try {
            return (ProbeInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProbeInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

