/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.omics;

import javax.annotation.Generated;

import com.amazonaws.services.omics.model.*;
import com.amazonaws.*;
import com.amazonaws.services.omics.waiters.AmazonOmicsWaiters;

/**
 * Abstract implementation of {@code AmazonOmics}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonOmics implements AmazonOmics {

    protected AbstractAmazonOmics() {
    }

    @Override
    public BatchDeleteReadSetResult batchDeleteReadSet(BatchDeleteReadSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelAnnotationImportJobResult cancelAnnotationImportJob(CancelAnnotationImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelRunResult cancelRun(CancelRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelVariantImportJobResult cancelVariantImportJob(CancelVariantImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAnnotationStoreResult createAnnotationStore(CreateAnnotationStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateReferenceStoreResult createReferenceStore(CreateReferenceStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRunGroupResult createRunGroup(CreateRunGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSequenceStoreResult createSequenceStore(CreateSequenceStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVariantStoreResult createVariantStore(CreateVariantStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkflowResult createWorkflow(CreateWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAnnotationStoreResult deleteAnnotationStore(DeleteAnnotationStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReferenceResult deleteReference(DeleteReferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteReferenceStoreResult deleteReferenceStore(DeleteReferenceStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRunResult deleteRun(DeleteRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRunGroupResult deleteRunGroup(DeleteRunGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSequenceStoreResult deleteSequenceStore(DeleteSequenceStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVariantStoreResult deleteVariantStore(DeleteVariantStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkflowResult deleteWorkflow(DeleteWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnnotationImportJobResult getAnnotationImportJob(GetAnnotationImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAnnotationStoreResult getAnnotationStore(GetAnnotationStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadSetResult getReadSet(GetReadSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadSetActivationJobResult getReadSetActivationJob(GetReadSetActivationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadSetExportJobResult getReadSetExportJob(GetReadSetExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadSetImportJobResult getReadSetImportJob(GetReadSetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReadSetMetadataResult getReadSetMetadata(GetReadSetMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReferenceResult getReference(GetReferenceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReferenceImportJobResult getReferenceImportJob(GetReferenceImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReferenceMetadataResult getReferenceMetadata(GetReferenceMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetReferenceStoreResult getReferenceStore(GetReferenceStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRunResult getRun(GetRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRunGroupResult getRunGroup(GetRunGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRunTaskResult getRunTask(GetRunTaskRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSequenceStoreResult getSequenceStore(GetSequenceStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVariantImportJobResult getVariantImportJob(GetVariantImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVariantStoreResult getVariantStore(GetVariantStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkflowResult getWorkflow(GetWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnnotationImportJobsResult listAnnotationImportJobs(ListAnnotationImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAnnotationStoresResult listAnnotationStores(ListAnnotationStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReadSetActivationJobsResult listReadSetActivationJobs(ListReadSetActivationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReadSetExportJobsResult listReadSetExportJobs(ListReadSetExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReadSetImportJobsResult listReadSetImportJobs(ListReadSetImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReadSetsResult listReadSets(ListReadSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReferenceImportJobsResult listReferenceImportJobs(ListReferenceImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReferenceStoresResult listReferenceStores(ListReferenceStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListReferencesResult listReferences(ListReferencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRunGroupsResult listRunGroups(ListRunGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRunTasksResult listRunTasks(ListRunTasksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRunsResult listRuns(ListRunsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSequenceStoresResult listSequenceStores(ListSequenceStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVariantImportJobsResult listVariantImportJobs(ListVariantImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVariantStoresResult listVariantStores(ListVariantStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkflowsResult listWorkflows(ListWorkflowsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAnnotationImportJobResult startAnnotationImportJob(StartAnnotationImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReadSetActivationJobResult startReadSetActivationJob(StartReadSetActivationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReadSetExportJobResult startReadSetExportJob(StartReadSetExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReadSetImportJobResult startReadSetImportJob(StartReadSetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartReferenceImportJobResult startReferenceImportJob(StartReferenceImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartRunResult startRun(StartRunRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartVariantImportJobResult startVariantImportJob(StartVariantImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAnnotationStoreResult updateAnnotationStore(UpdateAnnotationStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRunGroupResult updateRunGroup(UpdateRunGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVariantStoreResult updateVariantStore(UpdateVariantStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkflowResult updateWorkflow(UpdateWorkflowRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonOmicsWaiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
