/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.omics.model.ReferenceListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListReferencesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ReferenceListItem> references;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListReferencesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ReferenceListItem> getReferences() {
        return this.references;
    }

    public void setReferences(Collection<ReferenceListItem> references) {
        if (references == null) {
            this.references = null;
            return;
        }
        this.references = new ArrayList<ReferenceListItem>(references);
    }

    public ListReferencesResult withReferences(ReferenceListItem ... references) {
        if (this.references == null) {
            this.setReferences(new ArrayList<ReferenceListItem>(references.length));
        }
        for (ReferenceListItem ele : references) {
            this.references.add(ele);
        }
        return this;
    }

    public ListReferencesResult withReferences(Collection<ReferenceListItem> references) {
        this.setReferences(references);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getReferences() != null) {
            sb.append("References: ").append(this.getReferences());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReferencesResult)) {
            return false;
        }
        ListReferencesResult other = (ListReferencesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getReferences() == null ^ this.getReferences() == null) {
            return false;
        }
        return other.getReferences() == null || other.getReferences().equals(this.getReferences());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getReferences() == null ? 0 : this.getReferences().hashCode());
        return hashCode;
    }

    public ListReferencesResult clone() {
        try {
            return (ListReferencesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

