/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.protect.client;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.NoOpSigner;
import com.amazonaws.auth.RequestSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SignerAsRequestSigner;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.opensdk.config.ConnectionConfiguration;
import com.amazonaws.opensdk.config.ProxyConfiguration;
import com.amazonaws.opensdk.config.TimeoutConfiguration;
import com.amazonaws.opensdk.internal.auth.IamSignerFactory;
import com.amazonaws.opensdk.internal.auth.SignerProviderAdapter;
import com.amazonaws.opensdk.internal.config.ApiGatewayClientConfiguration;
import com.amazonaws.opensdk.internal.config.ClientConfigurationAdapter;
import com.amazonaws.opensdk.protect.auth.IamRequestSigner;
import com.amazonaws.opensdk.protect.auth.RequestSignerRegistry;
import com.amazonaws.opensdk.retry.RetryPolicyBuilder;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.retry.v2.RetryPolicy;
import com.amazonaws.util.VersionInfoUtils;
import java.net.BindException;
import java.net.ConnectException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.http.conn.ConnectTimeoutException;

public abstract class SdkSyncClientBuilder<Subclass extends SdkSyncClientBuilder, TypeToBuild> {
    private static final String USER_AGENT_PREFIX = "apig-java";
    private static final String UA_NAME_VERSION_SEPERATOR = "/";
    private AWSCredentialsProvider iamCredentials;
    private String endpoint;
    private String apiKey;
    private String region = this.defaultRegion();
    private RetryPolicy retryPolicy;
    private RequestSignerRegistry signerRegistry = new RequestSignerRegistry();
    private final ApiGatewayClientConfiguration apiGatewayClientConfiguration = new ApiGatewayClientConfiguration();
    private final ClientConfigurationFactory clientConfigFactory;

    protected SdkSyncClientBuilder(ClientConfigurationFactory clientConfigFactory) {
        this.clientConfigFactory = clientConfigFactory;
    }

    protected void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    protected void setIamCredentials(AWSCredentialsProvider iamCredentials) {
        this.iamCredentials = iamCredentials;
    }

    protected void setIamRegion(String iamRegion) {
        this.region = iamRegion;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Subclass endpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this.getSubclass();
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.apiGatewayClientConfiguration.setProxyConfiguration(proxyConfiguration);
    }

    public Subclass proxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.setProxyConfiguration(proxyConfiguration);
        return this.getSubclass();
    }

    public void setTimeoutConfiguration(TimeoutConfiguration timeoutConfiguration) {
        this.apiGatewayClientConfiguration.setTimeoutConfiguration(timeoutConfiguration);
    }

    public Subclass timeoutConfiguration(TimeoutConfiguration timeoutConfiguration) {
        this.setTimeoutConfiguration(timeoutConfiguration);
        return this.getSubclass();
    }

    public void setConnectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.apiGatewayClientConfiguration.setConnectionConfiguration(connectionConfiguration);
    }

    public Subclass connectionConfiguration(ConnectionConfiguration connectionConfiguration) {
        this.setConnectionConfiguration(connectionConfiguration);
        return this.getSubclass();
    }

    public Subclass retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this.getSubclass();
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    protected abstract URI defaultEndpoint();

    protected abstract String defaultRegion();

    protected Signer defaultIamSigner() {
        return new NoOpSigner();
    }

    protected IamSignerFactory signerFactory() {
        return new IamSignerFactory(this.region);
    }

    public final TypeToBuild build() {
        return this.build(new BuilderParams());
    }

    protected abstract TypeToBuild build(AwsSyncClientParams var1);

    private Subclass getSubclass() {
        return (Subclass)this;
    }

    protected Subclass signer(RequestSigner requestSigner, Class<? extends RequestSigner> signerType) {
        this.signerRegistry = this.signerRegistry.register(requestSigner, signerType);
        return this.getSubclass();
    }

    private RetryPolicy getDefaultRetryPolicy() {
        return RetryPolicyBuilder.standard().retryOnExceptions(ConnectException.class, BindException.class, ConnectTimeoutException.class).retryOnStatusCodes(429).backoffStrategy((BackoffStrategy)PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY_V2).maxNumberOfRetries(3).build();
    }

    private static class AnonymousCredentialsProvider
    implements AWSCredentialsProvider {
        private AnonymousCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            return null;
        }

        public void refresh() {
        }
    }

    private class BuilderParams
    extends AwsSyncClientParams {
        private BuilderParams() {
        }

        private AWSCredentialsProvider resolveCredentials() {
            return SdkSyncClientBuilder.this.iamCredentials == null ? new AnonymousCredentialsProvider() : SdkSyncClientBuilder.this.iamCredentials;
        }

        public AWSCredentialsProvider getCredentialsProvider() {
            return this.resolveCredentials();
        }

        public ClientConfiguration getClientConfiguration() {
            return this.resolveClientConfiguration();
        }

        private ClientConfiguration resolveClientConfiguration() {
            ClientConfiguration config = ClientConfigurationAdapter.adapt(SdkSyncClientBuilder.this.apiGatewayClientConfiguration, SdkSyncClientBuilder.this.clientConfigFactory.getConfig());
            if (SdkSyncClientBuilder.this.apiKey != null) {
                config.addHeader("x-api-key", SdkSyncClientBuilder.this.apiKey);
            }
            config.setUserAgentPrefix("apig-java/" + VersionInfoUtils.getVersion());
            return config;
        }

        public RequestMetricCollector getRequestMetricCollector() {
            return null;
        }

        public List<RequestHandler2> getRequestHandlers() {
            return Collections.emptyList();
        }

        public SignerProvider getSignerProvider() {
            if (SdkSyncClientBuilder.this.iamCredentials != null) {
                SdkSyncClientBuilder.this.signerRegistry = SdkSyncClientBuilder.this.signerRegistry.register((RequestSigner)new SignerAsRequestSigner(SdkSyncClientBuilder.this.defaultIamSigner(), SdkSyncClientBuilder.this.iamCredentials), IamRequestSigner.class);
            }
            return new SignerProviderAdapter(SdkSyncClientBuilder.this.signerRegistry);
        }

        public URI getEndpoint() {
            return SdkSyncClientBuilder.this.endpoint != null ? URI.create(SdkSyncClientBuilder.this.endpoint) : SdkSyncClientBuilder.this.defaultEndpoint();
        }

        public RetryPolicy getRetryPolicy() {
            return SdkSyncClientBuilder.this.retryPolicy == null ? SdkSyncClientBuilder.this.getDefaultRetryPolicy() : SdkSyncClientBuilder.this.retryPolicy;
        }
    }
}

