/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.protect.client;

import com.amazonaws.RequestConfig;
import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.ClientExecutionParams;
import com.amazonaws.client.ClientHandler;
import com.amazonaws.client.ClientHandlerImpl;
import com.amazonaws.client.ClientHandlerParams;
import com.amazonaws.opensdk.BaseRequest;
import com.amazonaws.opensdk.protect.client.RequestConfigAdapter;

@ThreadSafe
@Immutable
public class SdkClientHandler
extends ClientHandler {
    private final ClientHandler delegateHandler;

    public SdkClientHandler(ClientHandlerParams handlerParams) {
        this.delegateHandler = new ClientHandlerImpl(handlerParams);
    }

    public <Input, Output> Output execute(ClientExecutionParams<Input, Output> executionParams) {
        return (Output)this.delegateHandler.execute(this.addRequestConfig(executionParams));
    }

    public void shutdown() {
        this.delegateHandler.shutdown();
    }

    private <Input, Output> ClientExecutionParams<Input, Output> addRequestConfig(ClientExecutionParams<Input, Output> params) {
        return params.withRequestConfig((RequestConfig)new RequestConfigAdapter((BaseRequest)params.getInput()));
    }
}

