/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.protect.model.transform;

import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.opensdk.SdkResponseMetadata;
import com.amazonaws.opensdk.model.RawResult;
import com.amazonaws.opensdk.model.ResultContentConsumer;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.io.IOException;

public class RawResultUnmarshaller
implements Unmarshaller<RawResult, JsonUnmarshallerContext> {
    private final ResultContentConsumer resultContentConsumer;

    public RawResultUnmarshaller(ResultContentConsumer resultConsumer) {
        this.resultContentConsumer = resultConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawResult unmarshall(JsonUnmarshallerContext in) throws IOException {
        HttpResponse response = in.getHttpResponse();
        RawResult result = new RawResult();
        result.sdkResponseMetadata(new SdkResponseMetadata(SdkHttpMetadata.from((HttpResponse)response)));
        try {
            this.resultContentConsumer.consume(result, response.getContent());
        }
        finally {
            response.getContent().close();
        }
        return result;
    }
}

