/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk;

import com.amazonaws.annotation.Immutable;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.SdkHttpMetadata;
import java.util.Optional;

@Immutable
public class SdkResponseMetadata {
    public static final String HEADER_REQUEST_ID = "x-amzn-RequestId";
    private final SdkHttpMetadata httpMetadata;

    @SdkProtectedApi
    public SdkResponseMetadata(SdkHttpMetadata httpMetadata) {
        this.httpMetadata = httpMetadata;
    }

    public String requestId() {
        return (String)this.httpMetadata.getHttpHeaders().get(HEADER_REQUEST_ID);
    }

    public Optional<String> header(String headerName) {
        return Optional.ofNullable(this.httpMetadata.getHttpHeaders().get(headerName));
    }

    public int httpStatusCode() {
        return this.httpMetadata.getHttpStatusCode();
    }
}

