/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The SAML identity povider information.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SAMLIdp implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The metadata of the SAML application, in XML format.
     * </p>
     */
    private String metadataContent;
    /**
     * <p>
     * The unique entity ID of the application in the SAML identity provider.
     * </p>
     */
    private String entityId;

    /**
     * <p>
     * The metadata of the SAML application, in XML format.
     * </p>
     * 
     * @param metadataContent
     *        The metadata of the SAML application, in XML format.
     */

    public void setMetadataContent(String metadataContent) {
        this.metadataContent = metadataContent;
    }

    /**
     * <p>
     * The metadata of the SAML application, in XML format.
     * </p>
     * 
     * @return The metadata of the SAML application, in XML format.
     */

    public String getMetadataContent() {
        return this.metadataContent;
    }

    /**
     * <p>
     * The metadata of the SAML application, in XML format.
     * </p>
     * 
     * @param metadataContent
     *        The metadata of the SAML application, in XML format.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SAMLIdp withMetadataContent(String metadataContent) {
        setMetadataContent(metadataContent);
        return this;
    }

    /**
     * <p>
     * The unique entity ID of the application in the SAML identity provider.
     * </p>
     * 
     * @param entityId
     *        The unique entity ID of the application in the SAML identity provider.
     */

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    /**
     * <p>
     * The unique entity ID of the application in the SAML identity provider.
     * </p>
     * 
     * @return The unique entity ID of the application in the SAML identity provider.
     */

    public String getEntityId() {
        return this.entityId;
    }

    /**
     * <p>
     * The unique entity ID of the application in the SAML identity provider.
     * </p>
     * 
     * @param entityId
     *        The unique entity ID of the application in the SAML identity provider.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SAMLIdp withEntityId(String entityId) {
        setEntityId(entityId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMetadataContent() != null)
            sb.append("MetadataContent: ").append(getMetadataContent()).append(",");
        if (getEntityId() != null)
            sb.append("EntityId: ").append(getEntityId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SAMLIdp == false)
            return false;
        SAMLIdp other = (SAMLIdp) obj;
        if (other.getMetadataContent() == null ^ this.getMetadataContent() == null)
            return false;
        if (other.getMetadataContent() != null && other.getMetadataContent().equals(this.getMetadataContent()) == false)
            return false;
        if (other.getEntityId() == null ^ this.getEntityId() == null)
            return false;
        if (other.getEntityId() != null && other.getEntityId().equals(this.getEntityId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMetadataContent() == null) ? 0 : getMetadataContent().hashCode());
        hashCode = prime * hashCode + ((getEntityId() == null) ? 0 : getEntityId().hashCode());
        return hashCode;
    }

    @Override
    public SAMLIdp clone() {
        try {
            return (SAMLIdp) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.opensearch.model.transform.SAMLIdpMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
