/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearchserverless;

import javax.annotation.Generated;

import com.amazonaws.services.opensearchserverless.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSOpenSearchServerless}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSOpenSearchServerless implements AWSOpenSearchServerless {

    protected AbstractAWSOpenSearchServerless() {
    }

    @Override
    public BatchGetCollectionResult batchGetCollection(BatchGetCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetEffectiveLifecyclePolicyResult batchGetEffectiveLifecyclePolicy(BatchGetEffectiveLifecyclePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetLifecyclePolicyResult batchGetLifecyclePolicy(BatchGetLifecyclePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetVpcEndpointResult batchGetVpcEndpoint(BatchGetVpcEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccessPolicyResult createAccessPolicy(CreateAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCollectionResult createCollection(CreateCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLifecyclePolicyResult createLifecyclePolicy(CreateLifecyclePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSecurityConfigResult createSecurityConfig(CreateSecurityConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSecurityPolicyResult createSecurityPolicy(CreateSecurityPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVpcEndpointResult createVpcEndpoint(CreateVpcEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccessPolicyResult deleteAccessPolicy(DeleteAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCollectionResult deleteCollection(DeleteCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLifecyclePolicyResult deleteLifecyclePolicy(DeleteLifecyclePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSecurityConfigResult deleteSecurityConfig(DeleteSecurityConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSecurityPolicyResult deleteSecurityPolicy(DeleteSecurityPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVpcEndpointResult deleteVpcEndpoint(DeleteVpcEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccessPolicyResult getAccessPolicy(GetAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPoliciesStatsResult getPoliciesStats(GetPoliciesStatsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSecurityConfigResult getSecurityConfig(GetSecurityConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSecurityPolicyResult getSecurityPolicy(GetSecurityPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccessPoliciesResult listAccessPolicies(ListAccessPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCollectionsResult listCollections(ListCollectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLifecyclePoliciesResult listLifecyclePolicies(ListLifecyclePoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSecurityConfigsResult listSecurityConfigs(ListSecurityConfigsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSecurityPoliciesResult listSecurityPolicies(ListSecurityPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVpcEndpointsResult listVpcEndpoints(ListVpcEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccessPolicyResult updateAccessPolicy(UpdateAccessPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCollectionResult updateCollection(UpdateCollectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLifecyclePolicyResult updateLifecyclePolicy(UpdateLifecyclePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSecurityConfigResult updateSecurityConfig(UpdateSecurityConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSecurityPolicyResult updateSecurityPolicy(UpdateSecurityPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVpcEndpointResult updateVpcEndpoint(UpdateVpcEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
